package io.contract_testing.contractcase.definitions.interactions.base;

/**
 * The base class for all ContractCase Mock Descriptors. Extend this if you are implementing your own mock type.
 * <p>
 * If you are using the included example types from ContractCase (or any
 * extension libraries), you do not need to read the documentation for this
 * class.
 * <p>
 * Mock description type strings beginning with <code>_case:</code> are reserved for the default ContractCase
 * matchers. Only use a types prefixed with <code>_case:</code> if you wish to create a DSL for a special case
 * for a matching behaviour that is already provided by a core ContractCase mock.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.435Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.interactions.base.AnyInteractionDescriptor")
public abstract class AnyInteractionDescriptor extends software.amazon.jsii.JsiiObject {

    protected AnyInteractionDescriptor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AnyInteractionDescriptor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The base class for all ContractCase Mock Descriptors. Extend this if you are implementing your own mock type.
     * <p>
     * If you are using the included example types from ContractCase (or any
     * extension libraries), you do not need to read the documentation for this
     * class.
     * <p>
     * Mock description type strings beginning with <code>_case:</code> are reserved for the default ContractCase
     * matchers. Only use a types prefixed with <code>_case:</code> if you wish to create a DSL for a special case
     * for a matching behaviour that is already provided by a core ContractCase mock.
     * <p>
     * @param mockType <ul><li>The type string for this mock description (see <a href="https://case.contract-testing.io/docs/reference/plugin-framework">Extending ContractCase</a> for a description of these strings).</li></ul> This parameter is required.
     * @param setup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AnyInteractionDescriptor(final @org.jetbrains.annotations.NotNull java.lang.String mockType, final @org.jetbrains.annotations.NotNull io.contract_testing.contractcase.definitions.interactions.base.ContractCaseCoreSetup setup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(mockType, "mockType is required"), java.util.Objects.requireNonNull(setup, "setup is required") });
    }

    /**
     * This method returns the entire example as a JSON string, as a convenience so that wrapper libraries don't need to figure out how to walk a tree of example objects.
     * <p>
     * You shouldn't need to override this method.
     * <p>
     * @return A JSON string representation of this mock.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String stringify() {
        return software.amazon.jsii.Kernel.call(this, "stringify", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Only override this method if you are writing a matcher in a language other than TypeScript.
     * <p>
     * It exists because the ContractCase matcher format is not legal in all languages that ContractCase supports.
     * <p>
     * It isn't called by any implementation directly, it's used on the javascript side by <code>JSON.stringify()</code>.
     * <p>
     * Calling it from a wrapper library will return unhelpful results, as JSii can't map all objects that it returns.
     * <p>
     * WARNING: Do not return a string from this method. You must instead return
     * an object that can be serialised to JSON following the matcher format
     * described in <a href="https://case.contract-testing.io/docs/reference/plugin-framework">Extending ContractCase</a>.
     * <p>
     * @return An object in the matcher format described <a href="https://case.contract-testing.io/docs/reference/plugin-framework">in the Extending ContractCase documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends io.contract_testing.contractcase.definitions.interactions.base.AnyInteractionDescriptor {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
