/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.jsoup.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonVisitor;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlXPath
implements Processor {
    private final String fHtmlExpr;
    private final LinkedList<Updater> fUpdates;

    public HtmlXPath(ConfigLoadContext clc, JSONObject config) throws Builder.BuildFailure {
        try {
            this.fHtmlExpr = config.getString("htmlExpr");
            this.fUpdates = new LinkedList();
            JsonVisitor.forEachElement((JSONArray)config.getJSONArray("updates"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                public boolean visit(JSONObject updateInfo) throws JSONException, Builder.BuildFailure {
                    HtmlXPath.this.fUpdates.add(new Updater(updateInfo));
                    return true;
                }
            });
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    public void process(MessageProcessingContext context) {
        String html = context.evalExpression(this.fHtmlExpr);
        if (html == null || html.isEmpty()) {
            context.warn(this.fHtmlExpr + " evaluated to an empty string. XPath processing skipped.");
            return;
        }
        Document doc = Jsoup.parse((String)html);
        for (Updater u : this.fUpdates) {
            u.update(context, doc);
        }
    }

    private class Updater {
        private final String fPathExpr;
        private final String fTargetArrayExpr;
        private final String fTargetFieldExpr;
        private final String fTextFormat;

        public Updater(JSONObject updateInfo) throws Builder.BuildFailure {
            this.fPathExpr = updateInfo.getString("xpath");
            this.fTargetArrayExpr = updateInfo.optString("targetArray", null);
            this.fTargetFieldExpr = updateInfo.optString("targetField", null);
            this.fTextFormat = updateInfo.optString("format", "html");
            if (this.fTargetArrayExpr == null && this.fTargetFieldExpr == null) {
                throw new Builder.BuildFailure("Either targetArray or targetField must be specified in an XPath updater.");
            }
        }

        public void update(MessageProcessingContext context, Document doc) {
            String path = context.evalExpression(this.fPathExpr);
            if (path == null || path.isEmpty()) {
                context.warn(this.fPathExpr + " evaluated to an empty string. XPath processing skipped.");
                return;
            }
            if (this.fTargetArrayExpr != null) {
                String targetArray = context.evalExpression(this.fTargetArrayExpr);
                if (targetArray == null || targetArray.isEmpty()) {
                    context.warn(this.fTargetArrayExpr + " evaluated to an empty string. XPath update skipped.");
                    return;
                }
                Elements elements = doc.selectXpath(path);
                for (Element e : elements) {
                    context.getMessage().appendRawValue(targetArray, (Object)new JSONObject().put("html", (Object)e.outerHtml()).put("text", (Object)e.text()));
                }
            } else if (this.fTargetFieldExpr != null) {
                String targetField = context.evalExpression(this.fTargetFieldExpr);
                if (targetField == null || targetField.isEmpty()) {
                    context.warn(this.fTargetFieldExpr + " evaluated to an empty string. XPath update skipped.");
                    return;
                }
                Elements elements = doc.selectXpath(path);
                if (elements.isEmpty()) {
                    context.warn("XPath expression " + path + " returned nothing.");
                    return;
                }
                if (elements.size() > 1) {
                    context.warn("XPath expression " + path + " returned multiple elements. Only the first one will be used.");
                }
                Element el = elements.first();
                String val = null;
                if (this.fTextFormat.equals("html")) {
                    val = el.outerHtml();
                } else if (this.fTextFormat.equals("text")) {
                    val = el.text();
                } else if (this.fTextFormat.equals("object")) {
                    JSONObject attrs = new JSONObject();
                    for (Attribute attr : el.attributes()) {
                        attrs.put(attr.getKey(), (Object)attr.getValue());
                    }
                    val = new JSONObject().put("id", (Object)el.id()).put("attrs", (Object)attrs).put("text", (Object)el.text()).put("html", (Object)el.html());
                } else {
                    context.warn("Unknown text format: " + this.fTextFormat + ". Using 'html'.");
                    val = el.outerHtml();
                }
                context.getMessage().putRawValue(targetField, (Object)val);
            }
        }
    }
}

