/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.mrCommon;

import io.continual.onap.services.mrCommon.Clock;
import io.continual.onap.services.mrCommon.HttpHelper;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonClientBuilder {
    private final LinkedList<String> fHosts = new LinkedList();
    private boolean fDefaultHttps = false;
    private String fProxyHost = null;
    private int fProxyPort = 8888;
    private String fTopic = null;
    private HttpHelper.Credentials fCreds = HttpHelper.Credentials.anonymous();
    private long fWaitTimeoutMs = 30000L;
    private Logger fLog = defaultLog;
    private Clock fClock = new StdClock();
    private static final Logger defaultLog = LoggerFactory.getLogger((String)"io.continual.onap");

    public CommonClientBuilder withHost(String host) {
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("Invalid host value.");
        }
        this.fHosts.add(host);
        return this;
    }

    public CommonClientBuilder withHosts(Collection<String> hosts) {
        for (String host : hosts) {
            this.withHost(host);
        }
        return this;
    }

    public CommonClientBuilder withHosts(String[] hosts) {
        for (String host : hosts) {
            this.withHost(host);
        }
        return this;
    }

    public CommonClientBuilder forgetHosts() {
        this.fHosts.clear();
        return this;
    }

    public CommonClientBuilder defaultHttp() {
        return this.defaultHttps(false);
    }

    public CommonClientBuilder defaultHttps() {
        return this.defaultHttps(true);
    }

    public CommonClientBuilder defaultHttps(boolean https) {
        this.fDefaultHttps = https;
        return this;
    }

    public CommonClientBuilder usingProxy(String proxy) {
        if (proxy == null) {
            return this.usingProxy(null, 8888);
        }
        int colon = proxy.indexOf(58);
        if (colon > -1) {
            return this.usingProxy(proxy.substring(0, colon), Integer.parseInt(proxy.substring(colon + 1)));
        }
        return this.usingProxy(proxy, 8888);
    }

    public CommonClientBuilder usingProxy(String host, int port) {
        this.fProxyHost = host;
        this.fProxyPort = port;
        return this;
    }

    public CommonClientBuilder onTopic(String topic) {
        this.fTopic = topic;
        return this;
    }

    public CommonClientBuilder asUser(String user, String pwd) {
        this.fCreds = HttpHelper.Credentials.asUser(user, pwd);
        return this;
    }

    public CommonClientBuilder withApiKey(String apiKey, String apiSecret) {
        this.fCreds = HttpHelper.Credentials.withApiKey(apiKey, apiSecret);
        return this;
    }

    @Deprecated
    public CommonClientBuilder waitingAtMost(long ms) {
        return this.socketWaitAtMost(ms);
    }

    public CommonClientBuilder socketWaitAtMost(long ms) {
        this.fWaitTimeoutMs = ms;
        return this;
    }

    public CommonClientBuilder logTo(Logger log) {
        this.fLog = log;
        return this;
    }

    public CommonClientBuilder withClock(Clock clock) {
        this.fClock = clock;
        return this;
    }

    public List<String> getHosts() {
        return Collections.unmodifiableList(this.fHosts);
    }

    public boolean getDefaultHttps() {
        return this.fDefaultHttps;
    }

    public boolean isProxied() {
        return this.fProxyHost != null;
    }

    public String getProxyHost() {
        return this.fProxyHost;
    }

    public int getProxyPort() {
        return this.fProxyPort;
    }

    public Proxy getProxy() {
        if (this.isProxied()) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyHost(), this.getProxyPort()));
        }
        return null;
    }

    public String getTopic() {
        return this.fTopic;
    }

    public long getSocketWaitMs() {
        return this.fWaitTimeoutMs;
    }

    public Logger getLog() {
        return this.fLog;
    }

    public HttpHelper.Credentials getCredentials() {
        return this.fCreds;
    }

    public Clock getClock() {
        return this.fClock;
    }

    private static class StdClock
    implements Clock {
        private StdClock() {
        }

        @Override
        public long nowMs() {
            return System.currentTimeMillis();
        }
    }
}

