/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.mrCommon;

import io.continual.onap.services.mrCommon.JsonResponseParser;
import io.continual.onap.services.mrCommon.SimplifiedJsonTokener;
import io.continual.onap.services.subscriber.OnapMrFetchResponse;
import java.io.IOException;
import java.io.StringReader;

public class SimpleJsonResponseParser
implements JsonResponseParser {
    @Override
    public void parseResponseBody(String s, OnapMrFetchResponse resp) throws IOException {
        if (s == null || s.length() == 0) {
            resp.markEof();
            return;
        }
        try (StringReader sr = new StringReader(s);){
            block11: {
                SimplifiedJsonTokener t = new SimplifiedJsonTokener(sr);
                if (t.nextClean() != '[') {
                    throw new IOException("An array text must start with '['");
                }
                if (t.nextClean() != ']') {
                    char next;
                    t.back();
                    do {
                        resp.push(t.nextValue());
                        next = t.nextClean();
                        if (next == ']') break block11;
                    } while (next == ',');
                    throw new IOException("Expected a ',' or ']'");
                }
            }
            resp.markEof();
        }
        catch (SimplifiedJsonTokener.SimplifiedJsonException e) {
            throw new IOException(e);
        }
    }
}

