/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.subscriber;

import io.continual.onap.services.mrCommon.OnapMrResponse;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OnapMrFetchResponse
extends OnapMrResponse {
    private final LinkedList<String> fMsgs = new LinkedList();
    private boolean fEof = false;

    public OnapMrFetchResponse(int statusCode, String statusMsg) {
        super(statusCode, statusMsg);
    }

    public OnapMrFetchResponse(int statusCode, String statusMsg, List<String> msgs) {
        this(statusCode, statusMsg);
        this.fMsgs.addAll(msgs);
        this.fEof = true;
    }

    public synchronized OnapMrFetchResponse push(String msg) {
        if (this.fEof) {
            throw new IllegalStateException("Cannot add messages to a closed response.");
        }
        this.fMsgs.add(msg);
        this.notifyAll();
        return this;
    }

    public synchronized OnapMrFetchResponse markEof() {
        this.fEof = true;
        this.notifyAll();
        return this;
    }

    public synchronized boolean isEof() {
        return this.fMsgs.size() == 0 && this.fEof;
    }

    public synchronized int readyCount() {
        return this.fMsgs.size();
    }

    public synchronized String consumeNext(long timeoutMs) throws InterruptedException {
        if (this.isEof()) {
            return null;
        }
        if (this.fMsgs.size() > 0) {
            return this.fMsgs.remove();
        }
        this.wait(timeoutMs);
        if (this.fMsgs.size() > 0) {
            return this.fMsgs.remove();
        }
        return null;
    }

    @Deprecated
    public List<String> getMessages() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (!this.isEof()) {
                String msg = this.consumeNext(500L);
                if (msg == null) continue;
                result.add(msg);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }
}

