/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.publisher;

import io.continual.onap.services.mrCommon.Clock;
import io.continual.onap.services.mrCommon.CommonClientBuilder;
import io.continual.onap.services.mrCommon.HostSelector;
import io.continual.onap.services.mrCommon.HttpHelper;
import io.continual.onap.services.mrCommon.OnapMrResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;

public class OnapMsgRouterPublisher {
    private final HostSelector fHosts;
    private final String fTopic;
    private final long fWaitTimeoutMs;
    private final HttpHelper.Credentials fCreds;
    private final boolean fDefaultHttps;
    private final String fLabel;
    private final Clock fClock;
    private final OkHttpClient fHttpClient;
    private final Logger fLog;
    private static final MediaType kCambriaZip = MediaType.get((String)"application/cambria-zip");
    private static final Charset kUtf8 = Charset.forName("UTF-8");
    public static final String kPreferredDateFormat = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public static Builder localTest() {
        return new Builder().withHost("localhost").onTopic("TEST-TOPIC").waitingAtMost(30000L);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.fLabel;
    }

    public OnapMrResponse send(Message msg) {
        LinkedList<Message> msgs = new LinkedList<Message>();
        msgs.add(msg);
        return this.send(msgs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnapMrResponse send(List<Message> msgList) {
        ByteArrayOutputStream baos;
        if (msgList.size() < 1) {
            return HttpHelper.skAccepted;
        }
        try {
            baos = new ByteArrayOutputStream();
            GZIPOutputStream wrapperOs = new GZIPOutputStream(baos);
            for (Message m : msgList) {
                byte[] streamBytes = m.fStreamName.getBytes(kUtf8);
                byte[] payloadBytes = m.getBytesForSend();
                ((OutputStream)wrapperOs).write(("" + streamBytes.length).getBytes(kUtf8));
                ((OutputStream)wrapperOs).write(46);
                ((OutputStream)wrapperOs).write(("" + payloadBytes.length).getBytes(kUtf8));
                ((OutputStream)wrapperOs).write(46);
                ((OutputStream)wrapperOs).write(streamBytes);
                ((OutputStream)wrapperOs).write(payloadBytes);
                ((OutputStream)wrapperOs).write(10);
            }
            ((OutputStream)wrapperOs).close();
            baos.close();
        }
        catch (IOException e) {
            this.fLog.error("Error while building payload for MR publish. Returning 400 Bad Request. " + e.getMessage(), (Throwable)e);
            return new OnapMrResponse(400, "Unable to build payload.");
        }
        byte[] msgBody = baos.toByteArray();
        ArrayList<String> hostsLeft = new ArrayList<String>();
        this.fHosts.copyInto(hostsLeft);
        long noResponseTimeoutMs = this.fClock.nowMs() + this.fWaitTimeoutMs;
        while (this.fClock.nowMs() < noResponseTimeoutMs) {
            if (hostsLeft.size() <= 0) return HttpHelper.skSvcUnavailable;
            String host = hostsLeft.remove(0);
            String path = this.buildPath(host);
            RequestBody body = RequestBody.create((MediaType)kCambriaZip, (byte[])msgBody);
            Request.Builder reqBuilder = new Request.Builder().url(path).post(body);
            HttpHelper.addAuth(reqBuilder, this.fCreds, this.fClock);
            Request req = reqBuilder.build();
            this.fLog.info("POST {} ({})", (Object)path, (Object)this.fCreds.getUserDescription());
            long trxStartMs = this.fClock.nowMs();
            try {
                Response response = this.fHttpClient.newCall(req).execute();
                Throwable throwable = null;
                try {
                    long trxEndMs = this.fClock.nowMs();
                    long trxDurationMs = trxEndMs - trxStartMs;
                    int statusCode = response.code();
                    String statusText = response.message();
                    String responseBody = response.body().string();
                    this.fLog.info("    MR reply {} {} ({} ms): {}", new Object[]{statusCode, statusText, trxDurationMs, OnapMsgRouterPublisher.formatJsonTextForLog(responseBody)});
                    if (HttpHelper.isSuccess(statusCode) || HttpHelper.isClientFailure(statusCode)) {
                        OnapMrResponse onapMrResponse = new OnapMrResponse(statusCode, statusText);
                        return onapMrResponse;
                    }
                    if (!HttpHelper.isServerFailure(statusCode)) continue;
                    this.fHosts.demote(host);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException x) {
                long trxEndMs = this.fClock.nowMs();
                long trxDurationMs = trxEndMs - trxStartMs;
                this.fLog.warn("    MR failure for host [{}]: {} ({} ms)", new Object[]{host, x.getMessage(), trxDurationMs});
                this.fHosts.demote(host);
            }
        }
        return HttpHelper.skSvcUnavailable;
    }

    private String buildPath(String host) {
        StringBuilder sb = new StringBuilder();
        if (!host.contains("://")) {
            sb.append(this.fDefaultHttps ? "https://" : "http://");
        }
        sb.append(host);
        if (!host.contains(":")) {
            sb.append(host.startsWith("https://") ? ":3905" : ":3904");
        }
        sb.append("/events/");
        sb.append(HttpHelper.urlEncode(this.fTopic));
        return sb.toString();
    }

    Clock getClock() {
        return this.fClock;
    }

    private static String formatJsonTextForLog(String text) {
        return text.replaceAll("\\n", " ");
    }

    private OnapMsgRouterPublisher(Builder builder) {
        if (builder.getHosts().size() < 1) {
            throw new IllegalArgumentException("No hosts provided.");
        }
        if (builder.getTopic() == null || builder.getTopic().length() < 1) {
            throw new IllegalArgumentException("No topic provided.");
        }
        this.fHosts = HostSelector.builder().withHosts(builder.getHosts()).build();
        this.fTopic = builder.getTopic();
        this.fWaitTimeoutMs = builder.getSocketWaitMs();
        this.fDefaultHttps = builder.getDefaultHttps();
        this.fCreds = builder.getCredentials();
        if (builder.getLog() == null) {
            throw new IllegalArgumentException("You must provide a logger.");
        }
        this.fLog = builder.getLog();
        this.fClock = builder.getClock();
        OkHttpClient.Builder okb = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        Proxy proxy = builder.getProxy();
        if (proxy != null) {
            okb = okb.proxy(proxy);
        }
        this.fHttpClient = okb.build();
        this.fLabel = this.fTopic + " on " + this.fHosts.toString() + " as " + (this.fCreds.isAnonymous() ? "anonymous" : this.fCreds.getUserDescription());
    }

    public static class Message {
        public final String fStreamName;
        public final String fData;

        public Message(String eventStreamName, String payload) {
            this.fStreamName = eventStreamName;
            this.fData = payload;
        }

        public byte[] getBytesForSend() {
            return this.fData.toString().getBytes(kUtf8);
        }
    }

    public static class Builder
    extends CommonClientBuilder {
        @Override
        public Builder withHost(String host) {
            super.withHost(host);
            return this;
        }

        @Override
        public Builder withHosts(Collection<String> hosts) {
            super.withHosts(hosts);
            return this;
        }

        @Override
        public Builder withHosts(String[] hosts) {
            super.withHosts(hosts);
            return this;
        }

        @Override
        public Builder forgetHosts() {
            super.forgetHosts();
            return this;
        }

        @Override
        public Builder onTopic(String topic) {
            super.onTopic(topic);
            return this;
        }

        @Override
        public Builder waitingAtMost(long ms) {
            super.socketWaitAtMost(ms);
            return this;
        }

        @Override
        public Builder logTo(Logger log) {
            super.logTo(log);
            return this;
        }

        @Override
        public Builder asUser(String user, String pwd) {
            super.asUser(user, pwd);
            return this;
        }

        @Override
        public Builder withApiKey(String apiKey, String apiSecret) {
            super.withApiKey(apiKey, apiSecret);
            return this;
        }

        @Override
        public Builder defaultHttp() {
            return this.defaultHttps(false);
        }

        @Override
        public Builder defaultHttps() {
            return this.defaultHttps(true);
        }

        @Override
        public Builder defaultHttps(boolean https) {
            super.defaultHttps(https);
            return this;
        }

        @Override
        public Builder withClock(Clock clock) {
            super.withClock(clock);
            return this;
        }

        @Override
        public Builder usingProxy(String proxy) {
            super.usingProxy(proxy);
            return this;
        }

        @Override
        public Builder usingProxy(String host, int port) {
            super.usingProxy(host, port);
            return this;
        }

        public OnapMsgRouterPublisher build() {
            return new OnapMsgRouterPublisher(this);
        }
    }
}

