/*
 * Decompiled with CFR 0.152.
 */
package io.continual.monitor.runner;

import io.continual.services.Service;
import io.continual.services.processor.engine.library.filters.HasField;
import io.continual.services.processor.engine.library.processors.Log;
import io.continual.services.processor.engine.library.processors.SendToSink;
import io.continual.services.processor.engine.library.processors.ShiftDown;
import io.continual.services.processor.engine.library.sinks.RcvrSink;
import io.continual.services.processor.engine.library.sources.StdInSource;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.Pipeline;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Program;
import io.continual.services.processor.engine.model.Rule;
import io.continual.services.processor.engine.model.Sink;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.engine.runtime.Engine;
import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;

public class StdInToRcvr {
    public static void main(String[] args) {
        try {
            String sinkName = "rcvr";
            ExpressionEvaluator ee = new ExpressionEvaluator(new ExprDataSource[]{new EnvDataSource()});
            RcvrSink sink = new RcvrSink.Builder().sendingTo(ee.evaluateText("${CIO_RCVR_HOST}")).onTopic(ee.evaluateText("${CIO_RCVR_TOPIC}")).onStream(ee.evaluateText("${CIO_RCVR_STREAM}")).asUser(ee.evaluateText("${CIO_RCVR_USER}"), ee.evaluateText("${CIO_RCVR_PASSWORD}")).build();
            Program program = new Program().addSource("stdin", (Source)new StdInSource()).addSink("rcvr", (Sink)sink).addPipeline("default", new Pipeline().addRule(new Rule.Builder().checkIf((Filter)new HasField("application/json")).thenDo((Processor)new ShiftDown("application/json")).and((Processor)new SendToSink("rcvr")).build()).addRule(new Rule.Builder().alwaysDo((Processor)new Log()).build()));
            Engine engine = new Engine(program);
            engine.startAndWait();
        }
        catch (Service.FailedToStart e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

