/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient.impl.cache;

import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.ResponseCache;
import io.continual.util.data.HumanReadableHelper;
import io.continual.util.time.Clock;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapCache
implements ResponseCache,
AutoCloseable {
    public static final int kDefaultInitCapacity = 4096;
    public static final int kDefaultEstThreadCount = 8;
    public static final float kDefaultLoadFactor = 0.75f;
    public static final long kDefaultTimeoutMs = 900000L;
    private final ConcurrentHashMap<String, Entry> fMap;
    private final long fTimeoutMs;
    private final Thread fCleaner;
    private static final Logger log = LoggerFactory.getLogger(ConcurrentMapCache.class);

    public ConcurrentMapCache(final Builder b) {
        this.fMap = new ConcurrentHashMap(b.fInitCap, b.fLoadFactor, b.fThreadCount);
        this.fTimeoutMs = b.fTimeoutMs;
        this.fCleaner = b.fUseCleanupThread && b.fTimeoutMs >= 0L ? new Thread(){

            @Override
            public void run() {
                long everyMs = Math.min(Math.max(5000L, b.fTimeoutMs / 2L), 300000L);
                String everyStr = HumanReadableHelper.timeValue((long)everyMs, (TimeUnit)TimeUnit.MILLISECONDS, (long)1000L);
                log.info("ConcurrentMapCache will cleanup every {}...", (Object)everyStr);
                long startMs = Clock.now();
                long nextRunAtMs = startMs + everyMs;
                try {
                    while (true) {
                        Thread.sleep(Math.max(1L, nextRunAtMs - Clock.now()));
                        long now = Clock.now();
                        if (now < nextRunAtMs) continue;
                        log.info("Culling cache for max 500 ms...");
                        int removed = ConcurrentMapCache.this.cull(500L, TimeUnit.MILLISECONDS);
                        log.info("Culled {} timed out items; next run in ~{}", (Object)removed, (Object)everyStr);
                        nextRunAtMs = now + everyMs;
                    }
                }
                catch (InterruptedException e) {
                    log.info("Cache cleanup thread interrupted.");
                    log.info("Cache cleanup thread exiting.");
                    return;
                }
            }
        } : null;
    }

    public void start() {
        if (this.fCleaner != null) {
            this.fCleaner.start();
        }
    }

    @Override
    public void close() {
        log.info("Closing cache.");
        if (this.fCleaner != null) {
            this.fCleaner.interrupt();
        }
        this.fMap.clear();
    }

    @Override
    public JsonOverHttpClient.HttpResponse get(String path) {
        Entry e = this.fMap.get(path);
        if (e != null) {
            if (!e.isTimedOut()) {
                return e.getResponse();
            }
            this.fMap.remove(path);
        }
        return null;
    }

    @Override
    public void put(String path, JsonOverHttpClient.HttpResponse response) {
        this.fMap.put(path, new Entry(response));
    }

    @Override
    public void remove(String path) {
        this.fMap.remove(path);
    }

    public int cull(long maxDuration, TimeUnit tu) {
        int count = 0;
        long timeLimit = Clock.now() + TimeUnit.MILLISECONDS.convert(maxDuration, tu);
        TreeSet paths = new TreeSet(this.fMap.keySet());
        for (String path : paths) {
            if (Clock.now() > timeLimit) {
                return count;
            }
            Entry e = this.fMap.get(path);
            if (e == null || !e.isTimedOut()) continue;
            this.fMap.remove(path);
            ++count;
        }
        return count;
    }

    public static class Builder {
        private int fInitCap = 4096;
        private float fLoadFactor = 0.75f;
        private int fThreadCount = 8;
        private long fTimeoutMs = 900000L;
        private boolean fUseCleanupThread = true;

        public Builder withInitialCapacity(int cap) {
            this.fInitCap = cap;
            return this;
        }

        public Builder withLoadFactor(float lf) {
            this.fLoadFactor = lf;
            return this;
        }

        public Builder expectingThreadCount(int threads) {
            this.fThreadCount = threads;
            return this;
        }

        public Builder entriesTimingOutAfter(long duration, TimeUnit units) {
            this.fTimeoutMs = TimeUnit.MILLISECONDS.convert(duration, units);
            return this;
        }

        public Builder withoutTimeouts() {
            this.fTimeoutMs = -1L;
            return this;
        }

        public Builder runningCleanupThread() {
            this.fUseCleanupThread = true;
            return this;
        }

        public Builder withManualCleanup() {
            this.fUseCleanupThread = false;
            return this;
        }

        public ConcurrentMapCache build() {
            ConcurrentMapCache cmc = new ConcurrentMapCache(this);
            cmc.start();
            return cmc;
        }
    }

    private class Entry {
        private final JsonOverHttpClient.HttpResponse fResponse;
        private final long fGoodUntil;

        public Entry(JsonOverHttpClient.HttpResponse r) {
            this.fResponse = r;
            this.fGoodUntil = Clock.now() + ConcurrentMapCache.this.fTimeoutMs;
        }

        public boolean isTimedOut() {
            if (ConcurrentMapCache.this.fTimeoutMs < 0L) {
                return false;
            }
            return Clock.now() > this.fGoodUntil;
        }

        public JsonOverHttpClient.HttpResponse getResponse() {
            return this.fResponse;
        }
    }
}

