/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient.impl.cache;

import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.ResponseCache;
import io.continual.jsonHttpClient.impl.cache.ConcurrentMapCache;
import io.continual.util.data.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class CachingClient
implements JsonOverHttpClient {
    private final JsonOverHttpClient fClient;
    private final ResponseCache fCache;
    private final CacheControl fDefaultCacheControl;

    @Override
    public void close() {
        this.fCache.close();
    }

    @Override
    public CachingRequest newRequest() {
        return new CachingRequest();
    }

    private CachingClient(Builder b) {
        this.fClient = b.fBaseClient;
        this.fCache = b.fCache;
        this.fDefaultCacheControl = b.fControl;
        if (this.fClient == null) {
            throw new IllegalArgumentException("Missing base client.");
        }
        if (this.fCache == null) {
            throw new IllegalArgumentException("Missing cache implementation.");
        }
    }

    private JsonOverHttpClient.HttpResponse wrap(final JsonOverHttpClient.HttpResponse r) {
        try {
            return r.getBody(new JsonOverHttpClient.BodyFactory<CachedResponse>(){

                @Override
                public CachedResponse getBody(long contentLength, String mimeType, InputStream byteStream) throws JsonOverHttpClient.BodyFormatException {
                    try {
                        return new CachedResponse(r.getCode(), r.getMessage(), contentLength, mimeType, StreamTools.readBytes((InputStream)byteStream));
                    }
                    catch (IOException e) {
                        throw new JsonOverHttpClient.BodyFormatException(e);
                    }
                }
            });
        }
        catch (JsonOverHttpClient.BodyFormatException e) {
            return new CachedResponse(r.getCode(), r.getMessage(), e);
        }
    }

    private JsonOverHttpClient.HttpResponse wrap(JSONObject data) {
        byte[] bytes = data.toString().getBytes(StandardCharsets.UTF_8);
        return new CachedResponse(200, "OK", bytes.length, "application/json", bytes);
    }

    public class CachingRequest
    implements JsonOverHttpClient.HttpRequest {
        private JsonOverHttpClient.HttpRequest fPendingRequest;
        private String fPath;
        private CacheControl fCacheControl;

        public CachingRequest() {
            this.fPendingRequest = CachingClient.this.fClient.newRequest();
            this.fPath = null;
            this.fCacheControl = CachingClient.this.fDefaultCacheControl;
        }

        @Override
        public JsonOverHttpClient.HttpRequest onPath(String url) {
            this.fPendingRequest.onPath(url);
            this.fPath = url;
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest asUser(HttpUsernamePasswordCredentials creds) {
            this.fPendingRequest.asUser(creds);
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest withHeader(String key, String value) {
            this.fPendingRequest.withHeader(key, value);
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest withHeaders(Map<String, String> headers) {
            this.fPendingRequest.withHeaders(headers);
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest withExplicitQueryString(String qs) {
            this.fPendingRequest.withExplicitQueryString(qs);
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest addQueryParam(String key, String val) {
            this.fPendingRequest.addQueryParam(key, val);
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpRequest withQueryString(Map<String, String> qsMap) {
            this.fPendingRequest.withQueryString(qsMap);
            return this;
        }

        public CachingRequest withCache(CacheControl cc) {
            this.fCacheControl = cc;
            return this;
        }

        @Override
        public JsonOverHttpClient.HttpResponse get() throws JsonOverHttpClient.HttpServiceException {
            JsonOverHttpClient.HttpResponse cachedResponse = this.readCache();
            if (cachedResponse != null) {
                return cachedResponse;
            }
            JsonOverHttpClient.HttpResponse resp = this.fPendingRequest.get();
            return this.writeCache(resp);
        }

        @Override
        public JsonOverHttpClient.HttpResponse delete() throws JsonOverHttpClient.HttpServiceException {
            this.removeFromCache();
            return this.fPendingRequest.delete();
        }

        @Override
        public JsonOverHttpClient.HttpResponse put(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
            JsonOverHttpClient.HttpResponse resp = this.fPendingRequest.put(body);
            if (resp.isSuccess()) {
                this.writeCache(body);
            } else {
                this.removeFromCache();
            }
            return resp;
        }

        @Override
        public JsonOverHttpClient.HttpResponse patch(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
            this.removeFromCache();
            return this.fPendingRequest.patch(body);
        }

        @Override
        public JsonOverHttpClient.HttpResponse post(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
            this.removeFromCache();
            return this.fPendingRequest.post(body);
        }

        @Override
        public JsonOverHttpClient.HttpResponse post(JSONArray body) throws JsonOverHttpClient.HttpServiceException {
            this.removeFromCache();
            return this.fPendingRequest.post(body);
        }

        private JsonOverHttpClient.HttpResponse readCache() {
            JsonOverHttpClient.HttpResponse cachedResponse;
            if (this.fPath != null && this.fCacheControl.allowRead() && (cachedResponse = CachingClient.this.fCache.get(this.fPath)) != null) {
                return cachedResponse;
            }
            return null;
        }

        private JsonOverHttpClient.HttpResponse writeCache(JsonOverHttpClient.HttpResponse resp) {
            JsonOverHttpClient.HttpResponse result = resp;
            if (this.fCacheControl.allowWrite()) {
                result = CachingClient.this.wrap(resp);
                CachingClient.this.fCache.put(this.fPath, result);
            }
            return result;
        }

        private void writeCache(JSONObject body) {
            if (this.fCacheControl.allowWrite()) {
                CachingClient.this.fCache.put(this.fPath, CachingClient.this.wrap(body));
            }
        }

        private void removeFromCache() {
            if (this.fPath != null) {
                CachingClient.this.fCache.remove(this.fPath);
            }
        }
    }

    public static class Builder {
        private JsonOverHttpClient fBaseClient = null;
        private ResponseCache fCache = new ConcurrentMapCache.Builder().build();
        private CacheControl fControl = CacheControl.READ_AND_WRITE;

        public Builder overClient(JsonOverHttpClient baseClient) {
            this.fBaseClient = baseClient;
            return this;
        }

        public Builder withCache(ResponseCache cache) {
            this.fCache = cache;
            return this;
        }

        public CachingClient build() {
            return new CachingClient(this);
        }
    }

    public static enum CacheControl {
        NO_CACHE,
        READ_ONLY,
        WRITE_ONLY,
        READ_AND_WRITE;


        public boolean allowRead() {
            return this == READ_ONLY || this == READ_AND_WRITE;
        }

        public boolean allowWrite() {
            return this == WRITE_ONLY || this == READ_AND_WRITE;
        }
    }

    private class CachedResponse
    implements JsonOverHttpClient.HttpResponse {
        private final int fCode;
        private final String fMsg;
        private final long fLength;
        private final String fMimeType;
        private final byte[] fBytes;
        private final JsonOverHttpClient.BodyFormatException fEx;

        public CachedResponse(int code, String msg, long contentLength, String mimeType, byte[] bytes) {
            this.fCode = code;
            this.fMsg = msg;
            this.fLength = contentLength;
            this.fMimeType = mimeType;
            this.fBytes = bytes;
            this.fEx = null;
        }

        public CachedResponse(int code, String msg, JsonOverHttpClient.BodyFormatException x) {
            this.fCode = code;
            this.fMsg = msg;
            this.fLength = -1L;
            this.fMimeType = null;
            this.fBytes = null;
            this.fEx = x;
        }

        @Override
        public void close() {
        }

        @Override
        public int getCode() {
            return this.fCode;
        }

        @Override
        public String getMessage() {
            return this.fMsg;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T getBody(JsonOverHttpClient.BodyFactory<T> bf) throws JsonOverHttpClient.BodyFormatException {
            if (this.fEx != null) {
                throw this.fEx;
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(this.fBytes);){
                T t = bf.getBody(this.fLength, this.fMimeType, is);
                return t;
            }
            catch (IOException x) {
                throw new JsonOverHttpClient.BodyFormatException(x);
            }
        }
    }
}

