/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient;

import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.impl.ok.OkHttp;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.json.JSONObject;

public class JsonOverHttpClientBuilder {
    public static final String kCertValidation = "certValidation";
    public static final String kProxy = "proxy";
    public static final String kProxyHost = "host";
    public static final String kProxyPort = "port";
    public static final String kProxyType = "type";
    private Proxy fProxy = null;
    private boolean fCertValidation = true;

    public JsonOverHttpClientBuilder readJsonConfig(JSONObject config) {
        this.enableCertValidation(config.optBoolean(kCertValidation, true));
        JSONObject proxy = config.optJSONObject(kProxy);
        if (proxy != null) {
            String host = proxy.optString(kProxyHost);
            int port = proxy.optInt(kProxyPort, 8888);
            if (host != null && port > 0) {
                Proxy.Type type = Proxy.Type.HTTP;
                String typeStr = proxy.optString(kProxyType, Proxy.Type.HTTP.toString());
                if (typeStr != null) {
                    if (typeStr.equalsIgnoreCase(Proxy.Type.HTTP.toString())) {
                        type = Proxy.Type.HTTP;
                    } else if (typeStr.equalsIgnoreCase(Proxy.Type.SOCKS.toString())) {
                        type = Proxy.Type.SOCKS;
                    } else {
                        throw new IllegalArgumentException("Unexpected proxy type " + typeStr);
                    }
                }
                this.usingProxy(new Proxy(type, new InetSocketAddress(host, port)));
            }
        }
        return this;
    }

    public JsonOverHttpClientBuilder usingProxy(Proxy p) {
        this.fProxy = p;
        return this;
    }

    public JsonOverHttpClientBuilder enableCertValidation() {
        return this.enableCertValidation(true);
    }

    public JsonOverHttpClientBuilder disableCertValidation() {
        return this.enableCertValidation(false);
    }

    public JsonOverHttpClientBuilder enableCertValidation(boolean enable) {
        this.fCertValidation = enable;
        return this;
    }

    public JsonOverHttpClient build() {
        return new OkHttp(this.fProxy, !this.fCertValidation);
    }
}

