/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Timer;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Rule;
import java.util.ArrayList;
import java.util.List;

public class Pipeline {
    private final ArrayList<Rule> fRules = new ArrayList();

    public Pipeline() {
        this(new ArrayList<Rule>());
    }

    public Pipeline(List<Rule> rules) {
        this.fRules.addAll(rules);
    }

    public Pipeline addRule(Rule r) {
        this.fRules.add(r);
        return this;
    }

    public int size() {
        return this.fRules.size();
    }

    public void process(MessageProcessingContext context) {
        MetricsCatalog mc = context.getMetrics();
        int ruleIndex = 0;
        for (Rule r : this.fRules) {
            MetricsCatalog.PathPopper pp = mc.push("rule-" + ruleIndex++);
            try {
                Timer.Context ruleDurCtx = mc.timer("total").time();
                try {
                    String procChainLabel;
                    List<Processor> procs;
                    Filter f = r.getFilter();
                    if (f == null || f.passes(context)) {
                        procs = r.getThenProcs();
                        procChainLabel = "filterPass";
                    } else {
                        procs = r.getElseProcs();
                        procChainLabel = "filterFail";
                    }
                    try (MetricsCatalog.PathPopper pp2 = mc.push(procChainLabel);){
                        int procIndex = 0;
                        for (Processor p : procs) {
                            String procName = Pipeline.makeMetricsName(p, procIndex++);
                            MetricsCatalog.PathPopper pp3 = mc.push(procName);
                            try {
                                Timer.Context procDurCtx = mc.timer("totalTime").time();
                                try {
                                    p.process(context);
                                    if (context.shouldContinue()) continue;
                                    break;
                                }
                                finally {
                                    if (procDurCtx == null) continue;
                                    procDurCtx.close();
                                }
                            }
                            finally {
                                if (pp3 == null) continue;
                                pp3.close();
                            }
                        }
                    }
                    if (context.shouldContinue()) continue;
                    break;
                }
                finally {
                    if (ruleDurCtx == null) continue;
                    ruleDurCtx.close();
                }
            }
            finally {
                if (pp == null) continue;
                pp.close();
            }
        }
    }

    private static String makeMetricsName(Processor p, int i) {
        String clazz = p.getClass().getSimpleName().replaceAll("/", "-");
        return "proc-" + i + " (" + clazz + ")";
    }
}

