/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.util.data.StringUtils;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.data.json.JsonUtil;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Message
implements JsonSerialized {
    private final JSONObject fData;

    public static Message copyJsonToMessage(JSONObject data) {
        return new Message(data, true);
    }

    public static Message adoptJsonAsMessage(JSONObject data) {
        return new Message(data, false);
    }

    public Message() {
        this(new JSONObject(), false);
    }

    protected Message(JSONObject msgData, boolean clone) {
        this.fData = clone ? JsonUtil.clone((JSONObject)msgData) : msgData;
    }

    public Message clone() {
        return new Message(this.accessRawJson(), true);
    }

    public String toString() {
        return this.toJson().toString(4);
    }

    public String toLine() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fData);
    }

    public JSONObject accessRawJson() {
        return this.fData;
    }

    public boolean hasValue(String fieldName) {
        return this.hasValue(FieldSpec.fromString(fieldName));
    }

    public boolean hasValue(FieldSpec fs) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? false : container.has(fs.fField);
    }

    public String evalExpression(String expression) {
        return JsonEval.evalToString((JSONObject)this.fData, (String)expression);
    }

    public String getString(String field) {
        return this.getString(field, "");
    }

    public String getString(String field, String def) {
        return this.getString(FieldSpec.fromString(field), def);
    }

    public String getString(FieldSpec fs, String def) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? def : container.optString(fs.fField, def);
    }

    public boolean getBoolean(String field, boolean def) {
        return this.getBoolean(FieldSpec.fromString(field), def);
    }

    public boolean getBoolean(FieldSpec fs, boolean def) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? def : container.optBoolean(fs.fField, def);
    }

    public int getInt(String field, int i) {
        return this.getInt(FieldSpec.fromString(field), i);
    }

    public int getInt(FieldSpec fs, int def) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? def : container.optInt(fs.fField, def);
    }

    public long getLong(String field, long i) {
        return this.getLong(FieldSpec.fromString(field), i);
    }

    public long getLong(FieldSpec fs, long def) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? def : container.optLong(fs.fField, def);
    }

    public double getDouble(String field, double def) {
        return this.getDouble(FieldSpec.fromString(field), def);
    }

    public double getDouble(FieldSpec fs, double def) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? def : container.optDouble(fs.fField, def);
    }

    public Message putValue(String to, boolean val) {
        return this.putValue(FieldSpec.fromString(to), Boolean.valueOf(val));
    }

    public Message putValue(String to, double val) {
        return this.putValue(FieldSpec.fromString(to), Double.valueOf(val));
    }

    public Message putValue(String to, long val) {
        return this.putValue(FieldSpec.fromString(to), Long.valueOf(val));
    }

    public Message putValue(String to, String val) {
        return this.putValue(FieldSpec.fromString(to), val);
    }

    public Message putRawValue(String to, Object val) {
        return this.putValue(FieldSpec.fromString(to), val);
    }

    public <T> Message putValue(FieldSpec fs, T val) {
        JSONObject container = fs.getContainer(this.fData, true);
        if (container != null) {
            container.put(fs.fField, val);
        }
        return this;
    }

    public Message appendRawValue(String arrayKey, Object val) {
        JSONObject container = FieldSpec.fromString(arrayKey).getContainer(this.fData, true);
        JSONArray a = container.optJSONArray(arrayKey);
        if (a == null) {
            a = new JSONArray();
            container.put(arrayKey, (Object)a);
        }
        a.put(val);
        return this;
    }

    public Object getRawValue(String key) {
        return this.getRawValue(FieldSpec.fromString(key));
    }

    public Object getRawValue(FieldSpec fs) {
        JSONObject container = fs.getContainer(this.fData, false);
        return container == null ? null : container.opt(fs.fField);
    }

    public Message clearValue(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return this;
        }
        JSONObject data = JsonEval.getContainerOf((JSONObject)this.fData, (String)key);
        List pathParts = JsonEval.splitPath((String)key);
        if (data != null) {
            data.remove((String)pathParts.get(pathParts.size() - 1));
        }
        return this;
    }

    public static class FieldSpec {
        private final LinkedList<String> fContainers = new LinkedList();
        private final String fField;

        public static FieldSpec fromString(String key) {
            return new FieldSpec(key, true);
        }

        public static FieldSpec fromSimpleString(String key) {
            return new FieldSpec(key, false);
        }

        private FieldSpec(String key, boolean useDotSeps) {
            if (useDotSeps) {
                String[] parts = key.split("\\.");
                for (int i = 0; i < parts.length - 1; ++i) {
                    this.fContainers.add(parts[i]);
                }
                this.fField = parts[parts.length - 1];
            } else {
                this.fField = key;
            }
        }

        private JSONObject getContainer(JSONObject topLevel, boolean createIntermediates) {
            if (topLevel == null) {
                return null;
            }
            return JsonEval.getContainer((JSONObject)topLevel, this.fContainers, (boolean)createIntermediates);
        }
    }
}

