/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.QueuingSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.time.Clock;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageGenerator
extends QueuingSource {
    private final ExpressionEvaluator fExprEval;
    private final JSONObject fMessage;
    private long fCount;
    private final long fPauseMs;
    private long fNextMs;
    private long fSerialNumber = 0L;

    public MessageGenerator(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public MessageGenerator(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        try {
            this.fExprEval = config.optBoolean("skipEvals", false) ? null : sc.getServiceContainer().getExprEval();
            JSONObject given = config.optJSONObject("message");
            this.fMessage = given == null ? new JSONObject() : given;
            this.fCount = config.optLong("count", -1L);
            this.fPauseMs = config.optLong("everyMs", 1000L);
            if (this.fPauseMs < 1L) {
                throw new Builder.BuildFailure("'everyMs' interval must be at least 1 ms");
            }
            this.fNextMs = Clock.now() + config.optLong("initialPauseMs", this.fCount == 1L ? 0L : this.fPauseMs);
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    protected List<MessageAndRouting> reload() {
        ArrayList<MessageAndRouting> result = new ArrayList<MessageAndRouting>();
        if (Clock.now() >= this.fNextMs) {
            JSONObject msgData = JsonUtil.clone((JSONObject)this.fMessage).put("serialNumber", ++this.fSerialNumber);
            if (this.fExprEval != null) {
                msgData = this.fExprEval.evaluateJsonObject(msgData);
            }
            result.add(this.makeDefRoutingMessage(Message.adoptJsonAsMessage(msgData)));
            this.fNextMs += this.fPauseMs;
        }
        if (this.fPauseMs <= 0L) {
            this.noteEndOfStream();
            this.fNextMs = Long.MAX_VALUE;
        }
        return result;
    }
}

