/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.HumanReadableHelper;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxSource
extends BasicSource {
    private final long fPollFreqMs;
    private long fNextPollAtMs;
    private final boolean fRunOnce;
    private final JMXServiceURL fUrl;
    private final boolean fKeyHierarchy;
    private final boolean fSeparateMsgsPerMBean;
    private final List<JmxFetchSpec> fFetchSpecs;
    private final LinkedList<MessageAndRouting> fPending;
    private static final Logger log = LoggerFactory.getLogger(JmxSource.class);

    public JmxSource(ConfigLoadContext sc, JSONObject rawConfig) throws Builder.BuildFailure {
        super(rawConfig);
        try {
            JSONObject config = sc.getServiceContainer().getExprEval().evaluateJsonObject(rawConfig);
            this.fRunOnce = config.optBoolean("runOnce", false);
            if (!this.fRunOnce) {
                String pollEvery = config.optString("pollEvery", null);
                this.fPollFreqMs = HumanReadableHelper.parseDuration((String)pollEvery);
                if (this.fPollFreqMs <= 0L) {
                    throw new Builder.BuildFailure("Set pollEvery to be a positive value in milliseconds, or expressed like '1h' for every hour.");
                }
            } else {
                this.fPollFreqMs = 0L;
            }
            this.fNextPollAtMs = Clock.now();
            String host = config.optString("host", "localhost");
            int port = config.getInt("port");
            this.fUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi");
            this.fKeyHierarchy = config.optBoolean("jmxKeyHierarchy", true);
            this.fSeparateMsgsPerMBean = config.optBoolean("separateMsgsPerPollItem", true);
            this.fFetchSpecs = new LinkedList<JmxFetchSpec>();
            JSONArray specificQueries = config.optJSONArray("pollList");
            if (specificQueries != null) {
                JsonVisitor.forEachElement((JSONArray)specificQueries, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, JSONException>(){

                    public boolean visit(JSONObject querySpec) throws JSONException {
                        JmxSource.this.fFetchSpecs.add(new JmxFetchSpec(querySpec.optString("objectName", null)));
                        return true;
                    }
                });
            } else {
                this.fFetchSpecs.add(new JmxFetchSpec(null));
            }
            this.fPending = new LinkedList();
        }
        catch (MalformedURLException | JSONException e) {
            throw new Builder.BuildFailure(e);
        }
    }

    @Override
    protected MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) throws IOException, InterruptedException {
        if (this.fPending.size() > 0) {
            return this.fPending.removeFirst();
        }
        if (this.fNextPollAtMs < 0L) {
            this.noteEndOfStream();
            return null;
        }
        if (Clock.now() < this.fNextPollAtMs) {
            return null;
        }
        for (JSONObject msgData : this.populateMsgData()) {
            this.fPending.add(this.makeDefRoutingMessage(Message.adoptJsonAsMessage(msgData)));
        }
        this.fNextPollAtMs = this.fRunOnce ? -1L : Clock.now() + this.fPollFreqMs;
        return this.fPending.size() > 0 ? this.fPending.removeFirst() : null;
    }

    private JSONObject buildDataContainer(JSONObject domain, String keyprops) {
        JSONObject attrData;
        if (this.fKeyHierarchy) {
            String[] keyParts;
            JSONObject current = domain;
            for (String keyPart : keyParts = keyprops.split(",")) {
                JSONObject newContainer = current.optJSONObject(keyPart);
                if (newContainer == null) {
                    newContainer = new JSONObject();
                    current.put(keyPart, (Object)newContainer);
                }
                current = newContainer;
            }
            attrData = current;
        } else {
            attrData = new JSONObject();
            domain.put(keyprops, (Object)attrData);
        }
        return attrData;
    }

    private Object valToJson(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String || val instanceof Boolean || val instanceof Byte || val instanceof Character || val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof BigInteger || val instanceof BigDecimal) {
            return val;
        }
        if (val instanceof Float) {
            Float d = (Float)val;
            if (d.isInfinite() || d.isNaN()) {
                return "NaN";
            }
            return val;
        }
        if (val instanceof Double) {
            Double d = (Double)val;
            if (d.isInfinite() || d.isNaN()) {
                return "NaN";
            }
            return val;
        }
        if (val instanceof ObjectName) {
            return ((ObjectName)val).toString();
        }
        if (val instanceof CompositeDataSupport) {
            JSONObject obj = new JSONObject();
            CompositeDataSupport cds = (CompositeDataSupport)val;
            for (String key : cds.getCompositeType().keySet()) {
                obj.put(key, this.valToJson(cds.get(key)));
            }
            return obj;
        }
        if (val instanceof TabularDataSupport) {
            JSONArray obj = new JSONArray();
            TabularDataSupport tds = (TabularDataSupport)val;
            for (Object oo : tds.values()) {
                Object json = this.valToJson(oo);
                obj.put(json);
            }
            return obj;
        }
        if (val.getClass().isArray()) {
            JSONArray arr = new JSONArray();
            for (int i = 0; i < Array.getLength(val); ++i) {
                arr.put(this.valToJson(Array.get(val, i)));
            }
            return arr;
        }
        if (val instanceof List) {
            JSONArray arr = new JSONArray();
            for (Object o : (List)val) {
                arr.put(this.valToJson(o));
            }
            return arr;
        }
        if (val instanceof Set) {
            JSONArray arr = new JSONArray();
            for (Object o : (Set)val) {
                arr.put(this.valToJson(o));
            }
            return arr;
        }
        if (val instanceof Map) {
            JSONObject obj = new JSONObject();
            for (Map.Entry entry : ((Map)val).entrySet()) {
                obj.put(entry.getKey().toString(), this.valToJson(entry.getValue()));
            }
            return obj;
        }
        log.warn("Don't know how to convert {}", (Object)val.getClass().getCanonicalName());
        return null;
    }

    private List<JSONObject> populateMsgData() throws IOException {
        LinkedList<JSONObject> linkedList;
        block24: {
            LinkedList<JSONObject> result = new LinkedList<JSONObject>();
            JSONObject current = null;
            log.debug("Connecting to JMX @ {}", (Object)this.fUrl);
            JMXConnector jmxc = JMXConnectorFactory.connect(this.fUrl, null);
            try {
                MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                for (JmxFetchSpec q : this.fFetchSpecs) {
                    if (this.fSeparateMsgsPerMBean) {
                        if (current != null) {
                            result.add(current);
                        }
                        current = new JSONObject();
                    }
                    ObjectName objname = null;
                    String onStr = q.getObjName();
                    if (onStr != null) {
                        objname = new ObjectName(q.getObjName());
                    }
                    if (objname == null) continue;
                    TreeSet<ObjectName> mbeans = new TreeSet<ObjectName>();
                    if (objname.isPattern()) {
                        mbeans.addAll(mbsc.queryNames(null, objname));
                    } else {
                        mbeans.add(objname);
                    }
                    for (ObjectName mbean : mbeans) {
                        String objName = mbean.toString();
                        String[] parts = objName.split(":");
                        String domainStr = parts[0];
                        String keyprops = parts.length == 1 || parts[1] == null ? "" : parts[1];
                        log.info("Querying object {}...", (Object)objName);
                        JSONObject domain = current.optJSONObject(domainStr);
                        if (domain == null) {
                            domain = new JSONObject();
                            current.put(domainStr, (Object)domain);
                        }
                        JSONObject attrData = this.buildDataContainer(domain, keyprops);
                        try {
                            MBeanAttributeInfo[] attrInfo;
                            MBeanInfo info = mbsc.getMBeanInfo(mbean);
                            for (MBeanAttributeInfo attribute : attrInfo = info.getAttributes()) {
                                if (!attribute.isReadable()) continue;
                                log.debug("Getting value for attr {} {}...", (Object)objName, (Object)attribute.getName());
                                try {
                                    Object val = mbsc.getAttribute(mbean, attribute.getName());
                                    attrData.put(attribute.getName(), this.valToJson(val));
                                }
                                catch (RuntimeMBeanException x) {
                                    if (x.getCause() instanceof UnsupportedOperationException) {
                                        log.info("{} attribute {} is not supported. {}", new Object[]{objName, attribute.getName(), x.getMessage()});
                                        continue;
                                    }
                                    throw x;
                                }
                            }
                        }
                        catch (RuntimeMBeanException x) {
                            log.warn("RuntimeMBeanException on {} {}", (Object)objName, (Object)x.getMessage());
                        }
                        catch (Exception x) {
                            log.warn("Unable to retrieve data for {} {}", (Object)objName, (Object)x.getMessage());
                        }
                    }
                }
                if (current != null) {
                    result.add(current);
                }
                linkedList = result;
                if (jmxc == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (jmxc != null) {
                        try {
                            jmxc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedObjectNameException x) {
                    throw new IOException(x);
                }
            }
            jmxc.close();
        }
        return linkedList;
    }

    private static class JmxFetchSpec {
        private final String fObjName;

        public JmxFetchSpec(String objName) {
            this.fObjName = objName;
        }

        public String getObjName() {
            return this.fObjName;
        }
    }
}

