/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class InputStreamSource
extends BasicSource {
    private final BufferedReader fReader;
    private final boolean fWithClose;

    public InputStreamSource(InputStream is) {
        this(is, true);
    }

    public InputStreamSource(InputStream is, boolean withClose) {
        this.fReader = new BufferedReader(new InputStreamReader(is));
        this.fWithClose = withClose;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fWithClose) {
            this.fReader.close();
        }
        super.close();
    }

    @Override
    protected MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) throws IOException, InterruptedException {
        String line = this.fReader.readLine();
        if (line == null) {
            this.noteEndOfStream();
            return null;
        }
        JSONObject json = new JSONObject().put("text/plain", (Object)line);
        try {
            json.put("application/json", (Object)new JSONObject((JSONTokener)new CommentedJsonTokener(line)));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this.makeDefRoutingMessage(Message.adoptJsonAsMessage(json));
    }
}

