/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FileWatch
extends BasicSource {
    private final String fFilename;
    private long fLastChangeTimeMs;

    public FileWatch(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        this.fFilename = config.getString("file");
        boolean startWithRead = config.optBoolean("startWithRead", false);
        this.fLastChangeTimeMs = startWithRead ? 0L : this.getFileTimestamp(null);
    }

    @Override
    protected MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) {
        long currentChangeTimeMs = this.getFileTimestamp(spc);
        if (currentChangeTimeMs > this.fLastChangeTimeMs) {
            this.fLastChangeTimeMs = currentChangeTimeMs;
            try {
                return this.makeDefRoutingMessage(Message.adoptJsonAsMessage(this.loadFileData()));
            }
            catch (IOException x) {
                spc.warn(x.getMessage());
            }
        }
        return null;
    }

    private long getFileTimestamp(StreamProcessingContext spc) {
        Path path = Paths.get(this.fFilename, new String[0]);
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            if (spc != null) {
                spc.warn(e.getMessage());
            }
            return -1L;
        }
    }

    private JSONObject loadFileData() throws IOException {
        JSONObject jSONObject;
        Path path = Paths.get(this.fFilename, new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            jSONObject = new JSONObject((JSONTokener)new CommentedJsonTokener((InputStream)bais));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JSONException e) {
                return new JSONObject().put("content", (Object)new String(bytes));
            }
        }
        bais.close();
        return jSONObject;
    }
}

