/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.SimpleMessageAndRouting;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicSource
implements Source {
    private static final long[] skStdBackoffTimes = new long[]{1L, 1L, 2L, 3L, 5L, 8L, 13L, 21L, 34L, 55L, 89L, 144L, 233L, 377L, 610L, 987L};
    private final String fDefPipeline;
    private final ArrayList<MessageAndRouting> fRequeued;
    private boolean fEof = false;
    private static final Logger log = LoggerFactory.getLogger(BasicSource.class);

    @Override
    public synchronized boolean isEof() {
        return this.fRequeued.isEmpty() && this.fEof;
    }

    @Override
    public synchronized void close() throws IOException {
        this.noteEndOfStream();
    }

    @Override
    public synchronized void requeue(MessageAndRouting msgAndRoute) {
        this.fRequeued.add(msgAndRoute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MessageAndRouting getNextMessage(StreamProcessingContext spc, long timeUnit, TimeUnit units) throws IOException, InterruptedException {
        long[] backoff = this.getBackoffTimes();
        int backoffIndex = 0;
        long endByMs = Clock.now() + TimeUnit.MILLISECONDS.convert(timeUnit, units);
        do {
            BasicSource basicSource = this;
            synchronized (basicSource) {
                if (!this.fRequeued.isEmpty()) {
                    return this.fRequeued.remove(0);
                }
                if (this.isEof()) {
                    return null;
                }
                MessageAndRouting mr = this.internalGetNextMessage(spc);
                if (mr != null) {
                    return mr;
                }
            }
            long remainingMs = Math.max(0L, endByMs - Clock.now());
            if (remainingMs <= 0L) continue;
            long backoffTimeMs = Math.min(remainingMs, backoff[backoffIndex++]);
            if (backoffIndex == backoff.length) {
                backoffIndex = 0;
            }
            log.debug("... backing off {} ms", (Object)backoffTimeMs);
            Thread.sleep(backoffTimeMs);
        } while (Clock.now() < endByMs);
        return null;
    }

    @Override
    public synchronized void markComplete(StreamProcessingContext spc, MessageAndRouting mr) {
    }

    protected abstract MessageAndRouting internalGetNextMessage(StreamProcessingContext var1) throws IOException, InterruptedException;

    protected long[] getBackoffTimes() {
        return skStdBackoffTimes;
    }

    protected BasicSource(String defaultPipelineName) {
        this.fDefPipeline = defaultPipelineName == null ? "default" : defaultPipelineName;
        this.fRequeued = new ArrayList();
    }

    protected BasicSource(JSONObject config) {
        this(config.getString("pipeline"));
    }

    protected BasicSource() {
        this((String)null);
    }

    protected MessageAndRouting makeDefRoutingMessage(Message msg) {
        return new SimpleMessageAndRouting(msg, this.getDefaultPipelineName());
    }

    protected synchronized void noteEndOfStream() {
        this.fEof = true;
    }

    protected String getDefaultPipelineName() {
        return this.fDefPipeline;
    }
}

