/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sinks;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Sink;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.json.JSONObject;

public class FileSink
implements Sink {
    public static final String stdout = "stdout";
    public static final String stderr = "stderr";
    private final PrintStream fStream;
    private final boolean fCloseStream;
    private final String fLineFormat;
    private final String fHeader;
    private final String fFooter;

    public FileSink() throws Builder.BuildFailure {
        this(new JSONObject());
    }

    public FileSink(String stream) throws Builder.BuildFailure {
        this(new JSONObject().put("to", (Object)stream));
    }

    public FileSink(String stream, String lineFormat) throws Builder.BuildFailure {
        this(new JSONObject().put("to", (Object)stream).put("lineFormat", (Object)lineFormat));
    }

    public FileSink(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public FileSink(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        String to = config.optString("to", stdout);
        if (to.equals(stdout)) {
            this.fStream = System.out;
            this.fCloseStream = false;
        } else if (to.equals(stderr)) {
            this.fStream = System.err;
            this.fCloseStream = false;
        } else {
            try {
                this.fStream = new PrintStream(new FileOutputStream(new File(to), config.optBoolean("append", true)));
                this.fCloseStream = true;
            }
            catch (FileNotFoundException e) {
                throw new Builder.BuildFailure((Throwable)e);
            }
        }
        this.fLineFormat = config.optString("lineFormat", null);
        this.fHeader = config.optString("header", null);
        this.fFooter = config.optString("footer", null);
    }

    @Override
    public void init() {
        if (this.fHeader != null) {
            this.fStream.println(this.fHeader);
        }
    }

    @Override
    public void close() {
        if (this.fFooter != null) {
            this.fStream.println(this.fFooter);
        }
        if (this.fCloseStream) {
            this.fStream.close();
        }
    }

    @Override
    public void flush() {
        this.fStream.flush();
    }

    @Override
    public void process(MessageProcessingContext context) {
        String line = this.fLineFormat == null ? context.getMessage().toLine() : context.evalExpression(this.fLineFormat);
        this.fStream.println(line);
    }
}

