/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sinks;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Sink;
import java.io.PrintStream;
import org.json.JSONObject;

public class ConsoleSink
implements Sink {
    public static final String stdout = "stdout";
    public static final String stderr = "stderr";
    private final PrintStream fStream;

    public ConsoleSink() throws Builder.BuildFailure {
        this(new JSONObject());
    }

    public ConsoleSink(String stream) throws Builder.BuildFailure {
        this(new JSONObject().put("to", (Object)stream));
    }

    public ConsoleSink(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public ConsoleSink(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        String to = config.optString("to", stdout);
        if (to.equals(stdout)) {
            this.fStream = System.out;
        } else if (to.equals(stderr)) {
            this.fStream = System.err;
        } else {
            throw new Builder.BuildFailure("ConsoleSink requires to=stdout or stderr");
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void process(MessageProcessingContext mc) {
        this.fStream.println(mc.getMessage().toLine());
    }
}

