/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors.StringUtils;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonVisitor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Split
implements Processor {
    private final String fFrom;
    private final String fRegex;
    private final Pattern fPattern;
    private ArrayList<String> fTo;

    public Split(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fFrom = config.getString("from");
        this.fTo = new ArrayList();
        JsonVisitor.forEachElement((JSONArray)config.getJSONArray("to"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

            public boolean visit(String to) throws JSONException {
                Split.this.fTo.add(to);
                return true;
            }
        });
        this.fRegex = config.getString("regex");
        this.fPattern = Pattern.compile(this.fRegex);
    }

    @Override
    public void process(MessageProcessingContext context) {
        String val = context.evalExpression(this.fFrom);
        Matcher m = this.fPattern.matcher(val);
        if (m.matches()) {
            int groups = Math.min(m.groupCount(), this.fTo.size());
            for (int i = 0; i < groups; ++i) {
                String matchVal = m.group(i + 1);
                String key = this.fTo.get(i);
                context.getMessage().putValue(key, matchVal);
            }
        }
    }
}

