/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class CollapseRecords
implements Processor {
    private final LinkedList<String> fKeys = new LinkedList();
    private int fLastRecord = 0;

    public CollapseRecords() {
    }

    public CollapseRecords(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this();
        this.fKeys.addAll(JsonVisitor.arrayToList((JSONArray)config.optJSONArray("keys")));
    }

    public CollapseRecords onKey(String ... keyFields) {
        Collections.addAll(this.fKeys, keyFields);
        return this;
    }

    @Override
    public void process(MessageProcessingContext context) {
        if (this.fKeys == null) {
            return;
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (String key : this.fKeys) {
            vals.add(context.getMessage().getString(key));
        }
        int valHash = vals.hashCode();
        if (valHash == this.fLastRecord) {
            context.stopProcessing();
        }
        this.fLastRecord = valHash;
    }
}

