/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppendArray
implements Processor {
    public static final String kSetting_Target = "target";
    public static final String kSetting_Value = "value";
    private final String fTargetArray;
    private final Object fValue;

    public AppendArray(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fTargetArray = config.getString(kSetting_Target);
        this.fValue = config.get(kSetting_Value);
    }

    @Override
    public void process(final MessageProcessingContext context) {
        String val = null;
        if (this.fValue instanceof String) {
            val = context.evalExpression((String)this.fValue);
        } else if (this.fValue instanceof JSONObject) {
            final JSONObject target = new JSONObject();
            JsonVisitor.forEachElement((JSONObject)((JSONObject)this.fValue), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

                public boolean visit(String templateKey, Object templateValue) throws JSONException {
                    target.put(templateKey, (Object)context.evalExpression(templateValue.toString()));
                    return true;
                }
            });
            val = target;
        } else {
            context.warn("AppendArray does not know how to handle type " + this.fValue.getClass().getSimpleName() + ". Ignored.");
            return;
        }
        JSONArray array = context.getMessage().accessRawJson().optJSONArray(this.fTargetArray);
        if (array == null) {
            array = new JSONArray();
            context.getMessage().accessRawJson().put(this.fTargetArray, (Object)array);
        }
        array.put((Object)val);
    }
}

