/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.filters;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class Matches
implements Filter {
    private final String fPatternText;
    private final Pattern fPattern;
    private final String fValueExpr;

    public Matches(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(config);
    }

    public Matches(JSONObject config) throws Builder.BuildFailure {
        this.fValueExpr = config.getString("value");
        this.fPatternText = config.getString("pattern");
        this.fPattern = Pattern.compile(this.fPatternText);
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("class", (Object)this.getClass().getName()).put("pattern", (Object)this.fPatternText).put("value", (Object)this.fValueExpr);
        return result;
    }

    @Override
    public boolean passes(MessageProcessingContext ctx) {
        String value = ctx.evalExpression(this.fValueExpr);
        return this.fPattern.matcher(value).matches();
    }
}

