/*
 * Decompiled with CFR 0.152.
 */
package io.continual.metrics;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.MetricsService;
import io.continual.metrics.metricTypes.Gauge;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsCollector
extends SimpleService {
    private final MetricsCatalog fJmxCatalog;
    private final Thread fReloadGcThread = new Thread(() -> {
        while (this.isRunning()) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                break;
            }
            this.reloadGcGauges();
        }
    });
    private static final Logger log = LoggerFactory.getLogger(JmxMetricsCollector.class);

    public JmxMetricsCollector(ServiceContainer sc, JSONObject config) {
        MetricsService metrics = (MetricsService)sc.get("metrics", MetricsService.class);
        if (metrics == null) {
            log.warn("No metrics service available for JMX metrics collector");
            this.fJmxCatalog = null;
            return;
        }
        Path jmx = Path.getRootPath().makeChildItem(Name.fromString((String)"jmx"));
        this.fJmxCatalog = metrics.getCatalog(jmx);
        final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        Path mem = Path.getRootPath().makeChildItem(Name.fromString((String)"mem"));
        Path heap = mem.makeChildItem(Name.fromString((String)"heap"));
        Path nonHeap = mem.makeChildItem(Name.fromString((String)"nonHeap"));
        this.fJmxCatalog.gauge(heap.makeChildItem(Name.fromString((String)"usage")), () -> new Gauge<Long>(){

            @Override
            public Long getValue() {
                return memoryBean.getHeapMemoryUsage().getUsed();
            }
        });
        this.fJmxCatalog.gauge(heap.makeChildItem(Name.fromString((String)"max")), () -> new Gauge<Long>(){

            @Override
            public Long getValue() {
                return memoryBean.getHeapMemoryUsage().getMax();
            }
        });
        this.fJmxCatalog.gauge(heap.makeChildItem(Name.fromString((String)"pctUsed")), () -> new Gauge<Double>(){

            @Override
            public Double getValue() {
                long max = memoryBean.getHeapMemoryUsage().getMax();
                long used = memoryBean.getHeapMemoryUsage().getUsed();
                double pct = (double)Math.round((double)used / (double)max * 1000.0) / 10.0;
                return pct;
            }
        });
        this.fJmxCatalog.gauge(nonHeap.makeChildItem(Name.fromString((String)"usage")), () -> new Gauge<Long>(){

            @Override
            public Long getValue() {
                return memoryBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        Path threads = Path.getRootPath().makeChildItem(Name.fromString((String)"threads"));
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        this.fJmxCatalog.gauge(threads.makeChildItem(Name.fromString((String)"count")), () -> new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return threadBean.getThreadCount();
            }
        });
        this.fJmxCatalog.gauge(threads.makeChildItem(Name.fromString((String)"peak")), () -> new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return threadBean.getPeakThreadCount();
            }
        });
        this.fJmxCatalog.gauge(threads.makeChildItem(Name.fromString((String)"daemon")), () -> new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return threadBean.getDaemonThreadCount();
            }
        });
        this.fJmxCatalog.gauge(threads.makeChildItem(Name.fromString((String)"totalStarted")), () -> new Gauge<Long>(){

            @Override
            public Long getValue() {
                return threadBean.getTotalStartedThreadCount();
            }
        });
        Path os = Path.getRootPath().makeChildItem(Name.fromString((String)"os"));
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof OperatingSystemMXBean) {
            final OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
            this.fJmxCatalog.gauge(os.makeChildItem(Name.fromString((String)"sysCpu")), () -> new Gauge<Double>(){

                @Override
                public Double getValue() {
                    return (double)Math.round(sunOsBean.getSystemCpuLoad() * 10000.0) / 100.0;
                }
            });
            this.fJmxCatalog.gauge(os.makeChildItem(Name.fromString((String)"processCpu")), () -> new Gauge<Double>(){

                @Override
                public Double getValue() {
                    return (double)Math.round(sunOsBean.getProcessCpuLoad() * 10000.0) / 100.0;
                }
            });
        } else {
            log.warn("OS bean is not of type com.sun.management.OperatingSystemMXBean");
        }
        if (osBean instanceof UnixOperatingSystemMXBean) {
            final UnixOperatingSystemMXBean unixOsBean = (UnixOperatingSystemMXBean)osBean;
            this.fJmxCatalog.gauge(os.makeChildItem(Name.fromString((String)"fdOpen")), () -> new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return unixOsBean.getOpenFileDescriptorCount();
                }
            });
            this.fJmxCatalog.gauge(os.makeChildItem(Name.fromString((String)"fdMax")), () -> new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return unixOsBean.getMaxFileDescriptorCount();
                }
            });
        } else {
            log.warn("OS bean is not of type com.sun.management.UnixOperatingSystemMXBean");
        }
        final RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Path runtimePath = Path.getRootPath().makeChildItem(Name.fromString((String)"runtime"));
        this.fJmxCatalog.gauge(runtimePath.makeChildItem(Name.fromString((String)"uptime")), () -> new Gauge<Long>(){

            @Override
            public Long getValue() {
                return runtime.getUptime();
            }
        });
        this.reloadGcGauges();
    }

    protected void onStartRequested() throws Service.FailedToStart {
        this.fReloadGcThread.start();
    }

    private void reloadGcGauges() {
        Name gcName = Name.fromString((String)"gc");
        MetricsCatalog gcCat = this.fJmxCatalog.getSubCatalog(gcName);
        for (final GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            Path gcb = Path.getRootPath().makeChildItem(Name.fromString((String)gcBean.getName()));
            gcCat.gauge(gcb.makeChildItem(Name.fromString((String)"count")), () -> new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return gcBean.getCollectionCount();
                }
            });
            gcCat.gauge(gcb.makeChildItem(Name.fromString((String)"timeMs")), () -> new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return gcBean.getCollectionTime();
                }
            });
        }
    }
}

