/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.subpathWrapper;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.SimpleTraversal;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class SubpathWrapperModel
extends SimpleService
implements Model {
    private final Model fBackingModel;
    private final Path fBasePath;
    private final String fModelId;

    public SubpathWrapperModel(ServiceContainer sc, JSONObject config) throws JSONException, Builder.BuildFailure {
        this((Model)sc.getReqd(config.getString("backingModel"), Model.class), Path.fromString((String)config.getString("basePath")), config.getString("modelId"));
    }

    public SubpathWrapperModel(Model backingModel, Path basePath, String modelId) throws Builder.BuildFailure {
        this.fBackingModel = backingModel;
        this.fBasePath = basePath;
        this.fModelId = modelId;
    }

    @Override
    public String getId() {
        return this.fModelId;
    }

    @Override
    public long getMaxPathLength() {
        return this.fBackingModel.getMaxPathLength();
    }

    @Override
    public long getMaxRelnNameLength() {
        return this.fBackingModel.getMaxRelnNameLength();
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return this.fBackingModel.getMaxSerializedObjectLength();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return this.fBackingModel.getRequestContextBuilder();
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        return this.fBackingModel.exists(context, this.userPathToBackingModel(objectPath));
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path prefix, PageRequest pr) throws ModelServiceException, ModelRequestException {
        return ModelPathListPage.wrap(this.fBackingModel.listChildrenOfPath(context, this.userPathToBackingModel(prefix), pr), p -> this.backingPathToUser(p));
    }

    @Override
    public SubpathWrapperModel createIndex(String field) throws ModelRequestException, ModelServiceException {
        this.fBackingModel.createIndex(field);
        return this;
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        return null;
    }

    @Override
    public ModelTraversal startTraversal() throws ModelRequestException {
        return new SimpleTraversal(this);
    }

    @Override
    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.fBackingModel.load(context, this.userPathToBackingModel(objectPath), factory, userContext);
    }

    @Override
    public Model.ObjectUpdater createUpdate(ModelRequestContext context, Path objectPath) throws ModelRequestException, ModelServiceException {
        return this.fBackingModel.createUpdate(context, this.userPathToBackingModel(objectPath));
    }

    @Override
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        return this.fBackingModel.remove(context, this.userPathToBackingModel(objectPath));
    }

    @Override
    public Model setRelationType(ModelRequestContext context, String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        this.fBackingModel.setRelationType(context, relnName, rt);
        return this;
    }

    @Override
    public ModelRelationInstance relate(ModelRequestContext context, ModelRelation mr) throws ModelServiceException, ModelRequestException {
        return this.fBackingModel.relate(context, this.userPathToBackingModel(mr));
    }

    @Override
    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fBackingModel.unrelate(context, this.userPathToBackingModel(reln));
    }

    @Override
    public boolean unrelate(ModelRequestContext context, String relnId) throws ModelServiceException, ModelRequestException {
        return this.fBackingModel.unrelate(context, relnId);
    }

    @Override
    public Model.RelationSelector selectRelations(Path objectPath) {
        final Model.RelationSelector base = this.fBackingModel.selectRelations(this.userPathToBackingModel(objectPath));
        return new Model.RelationSelector(){

            @Override
            public Model.RelationSelector named(String name) {
                base.named(name);
                return this;
            }

            @Override
            public Model.RelationSelector inbound(boolean wantInbound) {
                base.inbound(wantInbound);
                return this;
            }

            @Override
            public Model.RelationSelector outbound(boolean wantOutbound) {
                base.outbound(wantOutbound);
                return this;
            }

            @Override
            public ModelRelationList getRelations(ModelRequestContext context) throws ModelServiceException, ModelRequestException {
                final ModelRelationList result = base.getRelations(context);
                return new ModelRelationList(){

                    @Override
                    public Iterator<ModelRelationInstance> iterator() {
                        final Iterator it = result.iterator();
                        return new Iterator<ModelRelationInstance>(){

                            @Override
                            public boolean hasNext() {
                                return it.hasNext();
                            }

                            @Override
                            public ModelRelationInstance next() {
                                return SubpathWrapperModel.this.backingPathToUser((ModelRelationInstance)it.next());
                            }
                        };
                    }
                };
            }
        };
    }

    private Path userPathToBackingModel(Path p) {
        return this.fBasePath.makeChildPath(p);
    }

    private Path backingPathToUser(Path p) {
        return p.makePathWithinParent(this.fBasePath);
    }

    private ModelRelation userPathToBackingModel(ModelRelation mr) {
        return ModelRelation.from(this.userPathToBackingModel(mr.getFrom()), mr.getName(), this.userPathToBackingModel(mr.getTo()));
    }

    private ModelRelationInstance backingPathToUser(ModelRelationInstance mr) {
        return ModelRelationInstance.from(this.backingPathToUser(mr.getFrom()), mr.getName(), this.backingPathToUser(mr.getTo()));
    }
}

