/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.ref.math;

import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessControlList;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BaseRelationSelector;
import io.continual.services.model.impl.common.ReadOnlyModel;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class FibonacciSequence
extends ReadOnlyModel {
    private static final AccessControlList kAcl = AccessControlList.builder().withEntry(AccessControlEntry.builder().permit().operation("read").forAllUsers().build()).build();
    private static final ModelObjectMetadata kMeta = new ModelObjectMetadata(){

        public JSONObject toJson() {
            return new JSONObject();
        }

        @Override
        public AccessControlList getAccessControlList() {
            return kAcl;
        }

        @Override
        public Set<String> getLockedTypes() {
            return new TreeSet<String>();
        }

        @Override
        public long getCreateTimeMs() {
            return 0L;
        }

        @Override
        public long getLastUpdateTimeMs() {
            return 0L;
        }

        @Override
        public long getVersionStamp() {
            return 0L;
        }

        @Override
        public long bumpVersionStamp() {
            throw new IllegalStateException("This is a read-only model.");
        }
    };
    private static final String kFirst = "first";
    private static final String kNext = "next";

    @Override
    public void close() {
    }

    @Override
    public String getId() {
        return "FibonacciSequence";
    }

    @Override
    public long getMaxPathLength() {
        return 100L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 10L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 1024L;
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) {
        try {
            return objectPath.isRootPath() || this.isFib(this.getNumberFrom(objectPath));
        }
        catch (NumberFormatException x) {
            return false;
        }
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path parentPath, PageRequest pr) {
        return ModelPathListPage.emptyList(pr);
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        throw new RuntimeException("query is not implemented");
    }

    @Override
    public ModelTraversal startTraversal() throws ModelRequestException {
        throw new RuntimeException("traversal is not implemented");
    }

    @Override
    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, final K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        if (!this.exists(context, objectPath)) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        final JSONObject data = new JSONObject();
        if (!objectPath.isRootPath()) {
            data.put("number", this.getNumberFrom(objectPath));
        }
        return factory.create(new ModelObjectFactory.ObjectCreateContext<K>(){

            @Override
            public ModelObjectMetadata getMetadata() {
                return kMeta;
            }

            @Override
            public ModelObject getData() {
                return new JsonModelObject(data);
            }

            @Override
            public K getUserContext() {
                return userContext;
            }
        });
    }

    @Override
    public Model.RelationSelector selectRelations(Path objectPath) {
        return new BaseRelationSelector<FibonacciSequence>(this, objectPath){

            @Override
            public ModelRelationList getRelations(ModelRequestContext context) throws ModelServiceException, ModelRequestException {
                Path p = this.getObject();
                LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
                if (FibonacciSequence.this.exists(context, p)) {
                    if (this.wantInbound()) {
                        if (p.equals((Object)FibonacciSequence.this.makePathFor(1L)) && this.nameMatches(FibonacciSequence.kFirst)) {
                            result.add(ModelRelationInstance.from(Path.getRootPath(), FibonacciSequence.kFirst, p));
                        } else if (!p.isRootPath() && this.nameMatches(FibonacciSequence.kNext)) {
                            result.add(ModelRelationInstance.from(FibonacciSequence.this.makePathFor(FibonacciSequence.this.prevFibFrom(FibonacciSequence.this.getNumberFrom(p))), FibonacciSequence.kNext, p));
                        }
                    }
                    if (this.wantOutbound()) {
                        if (p.isRootPath() && this.nameMatches(FibonacciSequence.kFirst)) {
                            result.add(ModelRelationInstance.from(p, FibonacciSequence.kFirst, FibonacciSequence.this.makePathFor(1L)));
                        } else if (!p.isRootPath() && this.nameMatches(FibonacciSequence.kNext)) {
                            result.add(ModelRelationInstance.from(p, FibonacciSequence.kNext, FibonacciSequence.this.makePathFor(FibonacciSequence.this.nextFibFrom(FibonacciSequence.this.getNumberFrom(p)))));
                        }
                    }
                }
                return ModelRelationList.simpleListOfCollection(result);
            }
        };
    }

    private Path makePathFor(long fib) {
        return Path.getRootPath().makeChildItem(Name.fromString((String)Long.toString(fib)));
    }

    private long getNumberFrom(Path objectPath) throws NumberFormatException {
        if (objectPath.isRootPath() || objectPath.getSegmentList().size() > 1) {
            throw new NumberFormatException("Not formatted as /<number>");
        }
        return Long.parseLong(objectPath.getSegment(0).toString());
    }

    private boolean isFib(long n) {
        if (n < 1L) {
            return false;
        }
        long first = 1L;
        long second = 1L;
        while (second <= n && second < Long.MAX_VALUE) {
            if (second == n) {
                return true;
            }
            long next = first + second;
            first = second;
            second = next;
        }
        return false;
    }

    private long nextFibFrom(long n) {
        if (n < 1L) {
            return 1L;
        }
        long first = 1L;
        long second = 1L;
        while (second <= n && second < Long.MAX_VALUE) {
            if (second == n) {
                return first + second;
            }
            long next = first + second;
            first = second;
            second = next;
        }
        throw new IllegalArgumentException();
    }

    private long prevFibFrom(long n) {
        if (n <= 1L) {
            return 1L;
        }
        long first = 1L;
        long second = 1L;
        while (second <= n && second < Long.MAX_VALUE) {
            if (second == n) {
                return first;
            }
            long next = first + second;
            first = second;
            second = next;
        }
        throw new IllegalArgumentException();
    }
}

