/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.ref.math;

import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessControlList;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BaseRelationSelector;
import io.continual.services.model.impl.common.ReadOnlyModel;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class CollatzSequence
extends ReadOnlyModel {
    private static final AccessControlList kAcl = AccessControlList.builder().withEntry(AccessControlEntry.builder().permit().operation("read").forAllUsers().build()).build();
    private static final ModelObjectMetadata kMeta = new ModelObjectMetadata(){

        public JSONObject toJson() {
            return new JSONObject();
        }

        @Override
        public AccessControlList getAccessControlList() {
            return kAcl;
        }

        @Override
        public Set<String> getLockedTypes() {
            return new TreeSet<String>();
        }

        @Override
        public long getCreateTimeMs() {
            return 0L;
        }

        @Override
        public long getLastUpdateTimeMs() {
            return 0L;
        }

        @Override
        public long getVersionStamp() {
            return 0L;
        }

        @Override
        public long bumpVersionStamp() {
            throw new IllegalStateException("This is a read-only model.");
        }
    };
    private static final String kNext = "next";

    @Override
    public void close() {
    }

    @Override
    public String getId() {
        return "CollatzSequence";
    }

    @Override
    public long getMaxPathLength() {
        return 100L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 10L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 1024L;
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) {
        try {
            return objectPath.isRootPath() || this.getNumberFrom(objectPath) > 0L;
        }
        catch (NumberFormatException x) {
            return false;
        }
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path parentPath, PageRequest pr) {
        return ModelPathListPage.emptyList(pr);
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        throw new RuntimeException("query is not implemented");
    }

    @Override
    public ModelTraversal startTraversal() throws ModelRequestException {
        throw new RuntimeException("traversal is not implemented");
    }

    @Override
    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, final K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        if (!this.exists(context, objectPath)) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        final JSONObject data = new JSONObject();
        if (!objectPath.isRootPath()) {
            data.put("number", this.getNumberFrom(objectPath));
        }
        return factory.create(new ModelObjectFactory.ObjectCreateContext<K>(){

            @Override
            public ModelObjectMetadata getMetadata() {
                return kMeta;
            }

            @Override
            public ModelObject getData() {
                return new JsonModelObject(data);
            }

            @Override
            public K getUserContext() {
                return userContext;
            }
        });
    }

    @Override
    public Model.RelationSelector selectRelations(Path objectPath) {
        return new BaseRelationSelector<CollatzSequence>(this, objectPath){

            @Override
            public ModelRelationList getRelations(ModelRequestContext context) throws ModelServiceException, ModelRequestException {
                Path p = this.getObject();
                LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
                if (CollatzSequence.this.exists(context, p)) {
                    if (this.wantInbound() && !p.isRootPath() && this.nameMatches(CollatzSequence.kNext)) {
                        for (long prior : CollatzSequence.this.prevCollatzFrom(CollatzSequence.this.getNumberFrom(p))) {
                            result.add(ModelRelationInstance.from(CollatzSequence.this.makePathFor(prior), CollatzSequence.kNext, p));
                        }
                    }
                    if (this.wantOutbound() && !p.isRootPath() && this.nameMatches(CollatzSequence.kNext)) {
                        result.add(ModelRelationInstance.from(p, CollatzSequence.kNext, CollatzSequence.this.makePathFor(CollatzSequence.this.nextCollatzFrom(CollatzSequence.this.getNumberFrom(p)))));
                    }
                }
                return ModelRelationList.simpleListOfCollection(result);
            }
        };
    }

    private Path makePathFor(long fib) {
        return Path.getRootPath().makeChildItem(Name.fromString((String)Long.toString(fib)));
    }

    private long getNumberFrom(Path objectPath) throws NumberFormatException {
        if (objectPath.isRootPath() || objectPath.getSegmentList().size() > 1) {
            throw new NumberFormatException("Not formatted as /<number>");
        }
        return Long.parseLong(objectPath.getSegment(0).toString());
    }

    private long nextCollatzFrom(long n) {
        if (n < 1L) {
            return 1L;
        }
        if (n % 2L == 0L) {
            return n / 2L;
        }
        return 3L * n + 1L;
    }

    private List<Long> prevCollatzFrom(long n) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (n < 1L) {
            return result;
        }
        result.add(n * 2L);
        long m = (n - 1L) / 3L;
        if (m > 0L) {
            result.add(m);
        }
        return result;
    }
}

