/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.iam.access.AccessControlList;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonModelObjectMetadata
implements ModelObjectMetadata {
    public static final String kMeta_AclTag = "acl";
    public static final String kMeta_CreateTs = "createMs";
    public static final String kMeta_UpdateTs = "updateMs";
    public static final String kMeta_VersionStamp = "versionStamp";
    public static final String kMeta_LockedTypes = "types";
    private final JSONObject fMeta;
    private final AccessControlList fAcl;

    public CommonModelObjectMetadata() {
        long updateTime = Clock.now();
        this.fMeta = new JSONObject().put(kMeta_CreateTs, updateTime).put(kMeta_UpdateTs, updateTime).put(kMeta_VersionStamp, 0L);
        this.fAcl = AccessControlList.createOpenAcl();
    }

    public static CommonModelObjectMetadata asCloneOfData(JSONObject meta) {
        return new CommonModelObjectMetadata(JsonUtil.clone((JSONObject)meta));
    }

    public static CommonModelObjectMetadata adoptingData(JSONObject meta) {
        return new CommonModelObjectMetadata(meta);
    }

    @Override
    public Set<String> getLockedTypes() {
        return new TreeSet<String>(JsonVisitor.arrayToList((JSONArray)this.fMeta.optJSONArray(kMeta_LockedTypes)));
    }

    @Override
    public long getCreateTimeMs() {
        return this.fMeta.optLong(kMeta_CreateTs, -1L);
    }

    @Override
    public long getLastUpdateTimeMs() {
        return this.fMeta.optLong(kMeta_UpdateTs, -1L);
    }

    @Override
    public long getVersionStamp() {
        return this.fMeta.optLong(kMeta_VersionStamp, 0L);
    }

    @Override
    public long bumpVersionStamp() {
        long newVersion = 1L + this.fMeta.optLong(kMeta_VersionStamp, 0L);
        this.fMeta.put(kMeta_VersionStamp, newVersion);
        return newVersion;
    }

    public JSONObject toJson() {
        this.packAcl();
        return JsonUtil.clone((JSONObject)this.fMeta);
    }

    @Override
    public AccessControlList getAccessControlList() {
        return this.fAcl;
    }

    private CommonModelObjectMetadata(JSONObject meta) {
        this.fMeta = meta;
        this.fAcl = AccessControlList.deserialize((JSONObject)meta.optJSONObject(kMeta_AclTag), null);
    }

    private void packAcl() {
        this.fMeta.put(kMeta_AclTag, (Object)this.fAcl.asJson());
    }
}

