/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.ModelOperation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchema;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelSchemaViolationException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.services.model.impl.common.SimpleTraversal;
import io.continual.services.model.impl.json.CommonModelObjectMetadata;
import io.continual.services.model.impl.json.CommonObjectData;
import io.continual.services.model.impl.json.CommonRelationSelector;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonJsonDbModel
extends SimpleService
implements Model {
    private final String fModelId;
    private final boolean fReadOnly;
    @Deprecated
    public static final String kMetadataTag = "\u24c2";
    @Deprecated
    public static final String kUserDataTag = "\u24ca";
    private static final Logger log = LoggerFactory.getLogger(CommonJsonDbModel.class);

    public CommonJsonDbModel(ServiceContainer sc, JSONObject config) {
        this(config.getString("modelId"), config.optBoolean("readOnly", false));
    }

    public CommonJsonDbModel(String modelId) {
        this(modelId, false);
    }

    public CommonJsonDbModel(String modelId, boolean readOnly) {
        this.fModelId = modelId;
        this.fReadOnly = readOnly;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return new BasicModelRequestContextBuilder();
    }

    @Override
    public String getId() {
        return this.fModelId;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0x40000000L;
    }

    @Override
    public long getMaxPathLength() {
        return 1024L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 1024L;
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        if (context.knownToNotExist(objectPath)) {
            return false;
        }
        boolean result = this.objectExists(context, objectPath);
        if (!result) {
            context.doesNotExist(objectPath);
        }
        return result;
    }

    @Override
    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, final K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        if (context.knownToNotExist(objectPath)) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        ModelDataTransfer ld = context.get(objectPath, ModelDataTransfer.class);
        if (ld == null) {
            ld = this.loadObject(context, objectPath);
            if (ld == null) {
                context.doesNotExist(objectPath);
                throw new ModelItemDoesNotExistException(objectPath);
            }
            context.put(objectPath, ld);
        }
        final ModelDataTransfer ldf = ld;
        ModelObjectFactory.ObjectCreateContext createContext = new ModelObjectFactory.ObjectCreateContext<K>(){

            @Override
            public ModelObjectMetadata getMetadata() {
                return ldf.getMetadata();
            }

            @Override
            public ModelObject getData() {
                return ldf.getObjectData();
            }

            @Override
            public K getUserContext() {
                return userContext;
            }
        };
        return factory.create(createContext);
    }

    @Override
    public Model.ObjectUpdater createUpdate(final ModelRequestContext context, final Path objectPath) throws ModelRequestException, ModelServiceException {
        this.checkReadOnly();
        return new Model.ObjectUpdater(){
            private final LinkedList<Update> fUpdates = new LinkedList();

            @Override
            public Model.ObjectUpdater overwriteData(ModelObject withData) {
                this.fUpdates.add(new Update(UpdateType.OVERWRITE_DATA, withData));
                return this;
            }

            @Override
            public Model.ObjectUpdater mergeData(ModelObject withData) {
                this.fUpdates.add(new Update(UpdateType.MERGE_DATA, withData));
                return this;
            }

            @Override
            public Model.ObjectUpdater replaceAcl(AccessControlList acl) {
                this.fUpdates.add(new Update(acl));
                return this;
            }

            @Override
            public Model.ObjectUpdater addTypeLock(String typeId) {
                this.fUpdates.add(new Update(UpdateType.ADD_TYPE_LOCK, typeId));
                return this;
            }

            @Override
            public Model.ObjectUpdater removeTypeLock(String typeId) {
                this.fUpdates.add(new Update(UpdateType.REMOVE_TYPE_LOCK, typeId));
                return this;
            }

            @Override
            public void execute() throws ModelRequestException, ModelSchemaViolationException, ModelServiceException {
                try {
                    CommonObjectData data;
                    ModelObjectMetadata meta;
                    boolean isCreate;
                    boolean bl = isCreate = !CommonJsonDbModel.this.exists(context, objectPath);
                    if (isCreate) {
                        meta = new CommonModelObjectMetadata();
                        Identity id = context.getOperator();
                        if (id != null) {
                            meta.getAccessControlList().setOwner(id.getId()).permit("~owner~", ModelOperation.kAllOperationStrings);
                        } else {
                            meta.getAccessControlList().addAclEntry(AccessControlEntry.builder().permit().forAllUsers().forAnyOperation().build());
                        }
                        data = new CommonObjectData();
                    } else {
                        BasicModelObject o = CommonJsonDbModel.this.load(context, objectPath);
                        meta = o.getMetadata();
                        data = new CommonObjectData(o.getData());
                    }
                    for (Update update : this.fUpdates) {
                        ModelOperation[] accessList;
                        AccessControlList acl = meta.getAccessControlList();
                        for (ModelOperation access : accessList = update.getAccessRequired()) {
                            Identity id = context.getOperator();
                            if (acl.canUser(id, access.toString())) continue;
                            String userId = id == null ? "Anonymous" : id.getId();
                            throw new ModelRequestException(userId + " may not " + String.valueOf(access) + " " + objectPath.toString() + ".");
                        }
                        update.update(context, meta, data);
                    }
                    meta.bumpVersionStamp();
                    ModelSchemaRegistry schemas = context.getSchemaRegistry();
                    for (String type : meta.getLockedTypes()) {
                        ModelSchema ms = schemas.getSchema(type);
                        if (ms == null) {
                            throw new ModelRequestException("Unknown type " + type);
                        }
                        ModelSchema.ValidationResult vr = ms.isValid(data);
                        if (vr.isValid()) continue;
                        throw new ModelRequestException("The object does not meet type " + type, new JSONObject().put("validationProblems", (Object)JsonVisitor.listToArray(vr.getProblems())));
                    }
                    ModelDataTransfer modelDataTransfer = new ModelDataTransfer(){

                        @Override
                        public ModelObjectMetadata getMetadata() {
                            return meta;
                        }

                        @Override
                        public ModelObject getObjectData() {
                            return data;
                        }
                    };
                    CommonJsonDbModel.this.internalStore(context, objectPath, modelDataTransfer);
                    log.info("wrote {}", (Object)objectPath);
                    context.put(objectPath, modelDataTransfer);
                    ModelNotificationService ns = context.getNotificationService();
                    if (isCreate) {
                        ns.onObjectCreate(objectPath);
                    } else {
                        ns.onObjectUpdate(objectPath);
                    }
                }
                catch (IamSvcException e) {
                    throw new ModelServiceException(e);
                }
            }
        };
    }

    @Override
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        this.checkReadOnly();
        boolean result = this.internalRemove(context, objectPath);
        context.remove(objectPath);
        log.info("removed {}", (Object)objectPath);
        context.getNotificationService().onObjectDelete(objectPath);
        return result;
    }

    @Override
    public Model createIndex(String field) throws ModelRequestException, ModelServiceException {
        this.checkReadOnly();
        return this;
    }

    @Override
    public ModelTraversal startTraversal() throws ModelRequestException {
        return new SimpleTraversal(this);
    }

    @Override
    public Model.RelationSelector selectRelations(Path objectPath) {
        return new CommonRelationSelector(this, objectPath);
    }

    protected boolean objectExists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        try {
            this.load(context, objectPath);
            return true;
        }
        catch (ModelItemDoesNotExistException e) {
            return false;
        }
    }

    protected abstract ModelDataTransfer loadObject(ModelRequestContext var1, Path var2) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException;

    protected abstract void internalStore(ModelRequestContext var1, Path var2, ModelDataTransfer var3) throws ModelRequestException, ModelServiceException;

    protected abstract boolean internalRemove(ModelRequestContext var1, Path var2) throws ModelRequestException, ModelServiceException;

    @Deprecated
    public abstract List<ModelRelationInstance> getInboundRelationsNamed(ModelRequestContext var1, Path var2, String var3) throws ModelServiceException, ModelRequestException;

    @Deprecated
    public abstract List<ModelRelationInstance> getOutboundRelationsNamed(ModelRequestContext var1, Path var2, String var3) throws ModelServiceException, ModelRequestException;

    protected void checkReadOnly() throws ModelRequestException {
        if (this.fReadOnly) {
            throw new ModelRequestException("This model was loaded as read-only.");
        }
    }

    protected static interface ModelDataTransfer {
        public ModelObjectMetadata getMetadata();

        public ModelObject getObjectData();
    }

    private class Update {
        public final UpdateType fType;
        public final ModelObject fData;
        public final AccessControlList fAcl;
        public final String fTypeId;

        public void update(ModelRequestContext context, ModelObjectMetadata meta, CommonObjectData workingData) {
            switch (this.fType.ordinal()) {
                case 2: {
                    AccessControlList targetAcl = meta.getAccessControlList();
                    targetAcl.clear();
                    targetAcl.setOwner(this.fAcl.getOwner());
                    for (AccessControlEntry e : this.fAcl.getEntries()) {
                        targetAcl.addAclEntry(e);
                    }
                    break;
                }
                case 0: {
                    workingData.clear();
                }
                case 1: {
                    workingData.merge(this.fData);
                    break;
                }
                case 3: {
                    meta.getLockedTypes().add(this.fTypeId);
                    break;
                }
                case 4: {
                    meta.getLockedTypes().remove(this.fTypeId);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown update type.");
                }
            }
        }

        public ModelOperation[] getAccessRequired() {
            if (this.fType == UpdateType.ACL) {
                return new ModelOperation[]{ModelOperation.ACL_UPDATE};
            }
            return new ModelOperation[]{ModelOperation.UPDATE};
        }

        private Update(AccessControlList acl) {
            this.fType = UpdateType.ACL;
            this.fData = null;
            this.fTypeId = null;
            this.fAcl = acl;
        }

        private Update(UpdateType ut, ModelObject data) {
            this.fType = ut;
            this.fData = data;
            this.fTypeId = null;
            this.fAcl = null;
        }

        private Update(UpdateType ut, String typeId) {
            this.fType = ut;
            this.fData = null;
            this.fTypeId = typeId;
            this.fAcl = null;
        }
    }

    private static enum UpdateType {
        OVERWRITE_DATA,
        MERGE_DATA,
        ACL,
        ADD_TYPE_LOCK,
        REMOVE_TYPE_LOCK;

    }
}

