/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.impl.json.CommonJsonDbModel;
import io.continual.services.model.impl.json.CommonModelObjectMetadata;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.naming.Path;
import org.json.JSONObject;

public class CommonDataTransfer
implements CommonJsonDbModel.ModelDataTransfer {
    private final JSONObject fData;
    private final CommonModelObjectMetadata fMetadata;
    public static final String kDataTag = "data";
    public static final String kMetaTag = "meta";

    public static JSONObject toDataObject(ModelObjectMetadata meta, ModelObject data) {
        return new JSONObject().put(kDataTag, (Object)JsonModelObject.modelObjectToJson(data)).put(kMetaTag, (Object)meta.toJson());
    }

    public static JSONObject toDataObject(CommonJsonDbModel.ModelDataTransfer o) {
        return CommonDataTransfer.toDataObject(o.getMetadata(), o.getObjectData());
    }

    public CommonDataTransfer(Path p, JSONObject fullObjectData) {
        JSONObject objData;
        if (fullObjectData == null) {
            fullObjectData = new JSONObject();
        }
        this.fData = (objData = fullObjectData.optJSONObject(kDataTag)) == null ? new JSONObject() : JsonUtil.clone((JSONObject)objData);
        JSONObject meta = fullObjectData.optJSONObject(kMetaTag);
        this.fMetadata = meta != null ? CommonModelObjectMetadata.asCloneOfData(meta) : new CommonModelObjectMetadata();
    }

    @Override
    public ModelObjectMetadata getMetadata() {
        return this.fMetadata;
    }

    @Override
    public ModelObject getObjectData() {
        return new JsonModelObject(this.fData);
    }
}

