/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.files;

import io.continual.builder.Builder;
import io.continual.iam.access.AccessControlList;
import io.continual.services.ServiceContainer;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectAndPath;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelOperation;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.SimpleModelQuery;
import io.continual.services.model.impl.files.FileSysRelnMgr;
import io.continual.services.model.impl.json.CommonDataTransfer;
import io.continual.services.model.impl.json.CommonJsonDbModel;
import io.continual.services.model.impl.json.CommonJsonDbObjectContainer;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.naming.Name;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemModel
extends CommonJsonDbModel {
    private static final String kOldDataTag = "\u24ca";
    private final File fBaseDir;
    private final FileSysRelnMgr fRelnMgr;
    private static final Logger log = LoggerFactory.getLogger(FileSystemModel.class);
    private static final String kRelnsDir = "relations";
    private static final Charset kUtf8 = Charset.forName("UTF8");

    public FileSystemModel(String modelId, String baseDir) throws Builder.BuildFailure {
        super(modelId);
        this.fBaseDir = new File(baseDir);
        if (!this.fBaseDir.exists() && !this.fBaseDir.mkdir()) {
            throw new Builder.BuildFailure("Failed to create " + this.fBaseDir.toString());
        }
        this.fRelnMgr = new FileSysRelnMgr(new File(this.fBaseDir, kRelnsDir));
    }

    public FileSystemModel(String acctId, String modelId, File baseDir) throws Builder.BuildFailure {
        this(modelId, baseDir.getAbsolutePath());
    }

    public FileSystemModel(String acctId, String modelId, Path path) throws Builder.BuildFailure {
        this(acctId, modelId, path.toFile());
    }

    public FileSystemModel(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this(sc.getExprEval(config).evaluateText(config.getString("modelId")), sc.getExprEval(config).evaluateText(config.getString("baseDir")));
    }

    @Override
    public long getMaxPathLength() {
        return 8160L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 255L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0xFFFFFFFFL;
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, io.continual.util.naming.Path prefix, PageRequest pr) throws ModelServiceException, ModelRequestException {
        LinkedList<io.continual.util.naming.Path> result = new LinkedList<io.continual.util.naming.Path>();
        File objDir = this.getObjectDir();
        File container = this.pathToDir(objDir, prefix);
        if (container.isFile()) {
            return ModelPathListPage.wrap(new LinkedList<io.continual.util.naming.Path>(), pr);
        }
        if (!container.isDirectory()) {
            if (container.equals(objDir)) {
                return ModelPathListPage.wrap(new LinkedList<io.continual.util.naming.Path>(), pr);
            }
            throw new ModelItemDoesNotExistException(prefix);
        }
        for (File obj : container.listFiles()) {
            result.add(prefix.makeChildItem(Name.fromString((String)obj.getName())));
        }
        return ModelPathListPage.wrap(result, pr);
    }

    @Override
    public FsModelQuery startQuery() {
        return new FsModelQuery();
    }

    @Override
    public Model setRelationType(ModelRequestContext context, String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        this.fRelnMgr.setRelationType(relnName, rt);
        return this;
    }

    @Override
    public ModelRelationInstance relate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.relate(reln);
    }

    @Override
    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.unrelate(reln);
    }

    @Override
    public boolean unrelate(ModelRequestContext context, String relnId) throws ModelServiceException, ModelRequestException {
        try {
            ModelRelationInstance mr = ModelRelationInstance.from(relnId);
            return this.unrelate(context, mr);
        }
        catch (IllegalArgumentException x) {
            throw new ModelRequestException(x);
        }
    }

    @Override
    public List<ModelRelationInstance> getInboundRelationsNamed(ModelRequestContext context, io.continual.util.naming.Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getInboundRelationsNamed(forObject, named);
    }

    @Override
    public List<ModelRelationInstance> getOutboundRelationsNamed(ModelRequestContext context, io.continual.util.naming.Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getOutboundRelationsNamed(forObject, named);
    }

    private File getFileFor(io.continual.util.naming.Path mop) {
        return new File(this.getObjectDir(), mop.toString());
    }

    @Override
    protected CommonDataTransfer loadObject(ModelRequestContext context, io.continual.util.naming.Path objectPath) throws ModelServiceException, ModelRequestException {
        File obj = this.getFileFor(objectPath);
        if (obj.isFile()) {
            AccessControlList acl;
            boolean oldModel;
            JSONObject rawData;
            try (FileInputStream fis = new FileInputStream(obj);){
                rawData = new JSONObject((JSONTokener)new CommentedJsonTokener((InputStream)fis));
            }
            catch (JSONException x) {
                throw new ModelRequestException("The object data is corrupt.");
            }
            catch (IOException x) {
                throw new ModelServiceException(x);
            }
            JSONObject inner = rawData.optJSONObject(kOldDataTag);
            boolean bl = oldModel = inner != null;
            if (oldModel) {
                rawData.remove(kOldDataTag);
                rawData.put("data", (Object)inner);
            }
            CommonDataTransfer loadedObj = new CommonDataTransfer(objectPath, rawData);
            if (oldModel && (acl = loadedObj.getMetadata().getAccessControlList()).getEntries().size() == 0) {
                acl.setOwner("_updated_").permit("*", ModelOperation.kAllOperationStrings);
            }
            return loadedObj;
        }
        if (obj.isDirectory()) {
            LinkedList<io.continual.util.naming.Path> result = new LinkedList<io.continual.util.naming.Path>();
            for (String child : obj.list()) {
                result.add(io.continual.util.naming.Path.getRootPath().makeChildItem(Name.fromString((String)child)));
            }
            return CommonJsonDbObjectContainer.createObjectContainer(objectPath, result);
        }
        if (objectPath.isRootPath()) {
            return CommonJsonDbObjectContainer.createObjectContainer(objectPath, new LinkedList<io.continual.util.naming.Path>());
        }
        if (!obj.exists()) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        throw new ModelServiceException("Path is corrupt: " + objectPath.toString());
    }

    @Override
    protected void internalStore(ModelRequestContext context, io.continual.util.naming.Path objectPath, CommonJsonDbModel.ModelDataTransfer o) throws ModelRequestException, ModelServiceException {
        File obj = this.getFileFor(objectPath);
        if (obj.exists() && !obj.isFile()) {
            throw new ModelRequestException(objectPath.toString() + " exists as a container.");
        }
        File parentDir = obj.getParentFile();
        if (parentDir.exists() && !parentDir.isDirectory()) {
            throw new ModelRequestException("Parent " + objectPath.getParentPath().toString() + " is an object.");
        }
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new ModelRequestException(objectPath.toString() + " parent path unavailable.");
        }
        try (FileOutputStream fos = new FileOutputStream(obj);){
            fos.write(CommonDataTransfer.toDataObject(o.getMetadata(), o.getObjectData()).toString().getBytes(kUtf8));
        }
        catch (IOException x) {
            throw new ModelServiceException(x);
        }
    }

    @Override
    protected boolean internalRemove(ModelRequestContext context, io.continual.util.naming.Path objectPath) throws ModelRequestException, ModelServiceException {
        File obj = this.getFileFor(objectPath);
        if (!obj.exists()) {
            return false;
        }
        if (obj.exists() && !obj.isFile()) {
            throw new ModelRequestException(objectPath.toString() + " exists as a container.");
        }
        this.fRelnMgr.removeAllRelations(objectPath);
        boolean removed = obj.delete();
        log.info("Removed object {} file {}", (Object)objectPath, (Object)obj);
        this.removeEmptyParents(obj);
        return removed;
    }

    static void removeEmptyDirsUpTo(File from, File limit) {
        File parentDir = from.getParentFile();
        if (parentDir.exists() && parentDir.isDirectory() && !parentDir.equals(limit) && parentDir.list().length == 0) {
            log.info("Removing empty dir {}", (Object)parentDir);
            parentDir.delete();
            FileSystemModel.removeEmptyDirsUpTo(parentDir, limit);
        }
    }

    private void removeEmptyParents(File from) {
        FileSystemModel.removeEmptyDirsUpTo(from, this.getObjectDir());
    }

    private File getObjectDir() {
        return new File(this.fBaseDir, "objects");
    }

    private File pathToDir(File base, io.continual.util.naming.Path p) {
        if (p.isRootPath()) {
            return base;
        }
        return new File(this.pathToDir(base, p.getParentPath()), p.getItemName().toString());
    }

    private class FsModelQuery
    extends SimpleModelQuery {
        private FsModelQuery() {
        }

        private List<io.continual.util.naming.Path> collectObjectsUnder(File dir, io.continual.util.naming.Path pathPrefix) {
            LinkedList<io.continual.util.naming.Path> result = new LinkedList<io.continual.util.naming.Path>();
            for (File f : dir.listFiles()) {
                String namePart = f.getName();
                io.continual.util.naming.Path p = pathPrefix.makeChildItem(Name.fromString((String)namePart));
                if (f.isFile()) {
                    result.add(p);
                    continue;
                }
                if (!f.isDirectory()) continue;
                result.addAll(this.collectObjectsUnder(f, p));
            }
            return result;
        }

        @Override
        public <T, K> ModelObjectList<T> execute(ModelRequestContext context, ModelObjectFactory<T, K> factory, final ModelQuery.DataAccessor<T> accessor, K userContext) throws ModelRequestException, ModelServiceException {
            long startIndex;
            Comparator<ModelObject> orderBy;
            final LinkedList<ModelObjectAndPath<T>> result = new LinkedList<ModelObjectAndPath<T>>();
            File objDir = FileSystemModel.this.getObjectDir();
            File container = FileSystemModel.this.pathToDir(objDir, this.getPathPrefix());
            if (container.isDirectory()) {
                for (io.continual.util.naming.Path p : this.collectObjectsUnder(container, this.getPathPrefix())) {
                    T mo = FileSystemModel.this.load(context, p, factory, userContext);
                    if (mo == null) continue;
                    boolean match = true;
                    for (SimpleModelQuery.Filter filter : this.getFilters()) {
                        if (filter.matches(accessor.getDataFrom(mo))) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    result.add(ModelObjectAndPath.from(p, mo));
                }
            }
            if ((orderBy = this.getOrdering()) != null) {
                Collections.sort(result, new Comparator<ModelObjectAndPath<T>>(){

                    @Override
                    public int compare(ModelObjectAndPath<T> o1, ModelObjectAndPath<T> o2) {
                        return orderBy.compare(accessor.getDataFrom(o1.getObject()), accessor.getDataFrom(o2.getObject()));
                    }
                });
            }
            long toDump = startIndex = (long)this.getPageSize() * (long)this.getPageNumber();
            while (toDump > 0L && result.size() > 0) {
                result.removeFirst();
            }
            while (result.size() > this.getPageSize()) {
                result.removeLast();
            }
            return new ModelObjectList<T>(){

                @Override
                public Iterator<ModelObjectAndPath<T>> iterator() {
                    return result.iterator();
                }
            };
        }
    }
}

