/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.files;

import io.continual.builder.Builder;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.files.FileSystemModel;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

class FileSysRelnMgr {
    private final File fRelnDir;

    public FileSysRelnMgr(File relnDir) throws Builder.BuildFailure {
        this.fRelnDir = relnDir;
        if (!this.fRelnDir.exists() && !this.fRelnDir.mkdir()) {
            throw new Builder.BuildFailure("Failed to create " + relnDir.toString());
        }
        if (!this.fRelnDir.isDirectory()) {
            throw new Builder.BuildFailure(relnDir.toString() + " exists and is not a directory.");
        }
    }

    public void setRelationType(String relnName, Model.RelationType rt) {
    }

    public ModelRelationInstance relate(ModelRelation mr) throws ModelServiceException, ModelRequestException {
        this.addToRelnFile(this.pathToObjOutDir(mr.getFrom()), mr.getName(), mr.getTo());
        this.addToRelnFile(this.pathToObjInDir(mr.getTo()), mr.getName(), mr.getFrom());
        return ModelRelationInstance.from(mr);
    }

    public boolean unrelate(ModelRelation reln) throws ModelServiceException, ModelRequestException {
        File outRelnDir = new File(this.pathToObjOutDir(reln.getFrom()), reln.getName());
        File inRelnDir = new File(this.pathToObjInDir(reln.getTo()), reln.getName());
        boolean out = this.removeFromRelnFile(outRelnDir, reln.getTo());
        boolean in = this.removeFromRelnFile(inRelnDir, reln.getFrom());
        FileSystemModel.removeEmptyDirsUpTo(outRelnDir, this.fRelnDir);
        FileSystemModel.removeEmptyDirsUpTo(inRelnDir, this.fRelnDir);
        return out || in;
    }

    public void removeAllRelations(Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelationInstance> relns = new LinkedList<ModelRelationInstance>();
        relns.addAll(this.getInboundRelationsNamed(forObject, null));
        relns.addAll(this.getOutboundRelationsNamed(forObject, null));
        for (ModelRelation modelRelation : relns) {
            this.unrelate(modelRelation);
        }
    }

    public List<ModelRelationInstance> getInboundRelationsNamed(Path forObject, String named) throws ModelServiceException, ModelRequestException {
        if (named == null) {
            LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
            File objDir = this.pathToObjInDir(forObject);
            if (objDir.isDirectory()) {
                for (File reln : objDir.listFiles()) {
                    result.addAll(this.getRelationsFrom(forObject, reln, false));
                }
            }
            return result;
        }
        File reln = new File(this.pathToObjInDir(forObject), named);
        if (reln.exists()) {
            return this.getRelationsFrom(forObject, reln, false);
        }
        return new LinkedList<ModelRelationInstance>();
    }

    public List<ModelRelationInstance> getOutboundRelationsNamed(Path forObject, String named) throws ModelServiceException, ModelRequestException {
        if (named == null) {
            LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
            File objDir = this.pathToObjOutDir(forObject);
            if (objDir.isDirectory()) {
                for (File reln : objDir.listFiles()) {
                    result.addAll(this.getRelationsFrom(forObject, reln, true));
                }
            }
            return result;
        }
        File reln = new File(this.pathToObjOutDir(forObject), named);
        if (reln.exists()) {
            return this.getRelationsFrom(forObject, reln, true);
        }
        return new LinkedList<ModelRelationInstance>();
    }

    private List<ModelRelationInstance> getRelationsFrom(Path forObject, File reln, boolean objIsFromSide) throws ModelServiceException {
        LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
        String relnName = reln.getName();
        for (Path to : this.loadToList(reln)) {
            result.add(ModelRelationInstance.from(objIsFromSide ? forObject : to, relnName, objIsFromSide ? to : forObject));
        }
        return result;
    }

    private List<Path> loadToList(File relnFile) throws ModelServiceException {
        block9: {
            if (relnFile.exists()) {
                LinkedList<Path> linkedList;
                FileInputStream fis2 = new FileInputStream(relnFile);
                try {
                    JSONArray ar = new JSONArray((JSONTokener)new CommentedJsonTokener((InputStream)fis2));
                    List list = JsonVisitor.arrayToList((JSONArray)ar, (JsonVisitor.ValueReader)new JsonVisitor.ValueReader<String, Path>(){

                        public Path read(String val) {
                            return Path.fromString((String)val);
                        }
                    });
                    LinkedList<Path> result = new LinkedList<Path>();
                    result.addAll(list);
                    linkedList = result;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fis2) {
                        break block9;
                    }
                    catch (IOException | JSONException x) {
                        throw new ModelServiceException(x);
                    }
                }
                fis2.close();
                return linkedList;
            }
        }
        return new LinkedList<Path>();
    }

    private void storeToFile(File relnFile, List<Path> list) throws ModelServiceException {
        block8: {
            if (list.size() > 0) {
                JSONArray arr = JsonVisitor.listToArray(list, (JsonVisitor.ItemRenderer)new JsonVisitor.ItemRenderer<Path, String>(){

                    public String render(Path t) {
                        return t.toString();
                    }
                });
                try (FileWriter fw = new FileWriter(relnFile);){
                    fw.write(arr.toString());
                    break block8;
                }
                catch (IOException x) {
                    throw new ModelServiceException(x);
                }
            }
            relnFile.delete();
        }
    }

    private File pathToObjDir(Path from) {
        File result = this.fRelnDir;
        for (Name component : from.getSegmentList()) {
            result = new File(result, component.toString());
        }
        return result;
    }

    private File pathToObjOutDir(Path from) {
        return new File(this.pathToObjDir(from), "out");
    }

    private File pathToObjInDir(Path from) {
        return new File(this.pathToObjDir(from), "in");
    }

    private void addToRelnFile(File targetDir, String relnName, Path farSide) throws ModelServiceException {
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            throw new ModelServiceException("Couldn't create relation directory " + targetDir.toString());
        }
        File pathFile = new File(targetDir, relnName);
        List<Path> farSideList = this.loadToList(pathFile);
        farSideList.add(farSide);
        this.storeToFile(pathFile, farSideList);
    }

    private boolean removeFromRelnFile(File relnFile, Path farSide) throws ModelServiceException {
        List<Path> toList;
        if (relnFile.exists() && (toList = this.loadToList(relnFile)).contains(farSide)) {
            toList.remove(farSide);
            this.storeToFile(relnFile, toList);
            return true;
        }
        return false;
    }
}

