/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.file;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectAndPath;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.SimpleModelQuery;
import io.continual.services.model.impl.json.CommonDataTransfer;
import io.continual.services.model.impl.json.CommonJsonDbModel;
import io.continual.util.collections.MultiMap;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SingleFileModel
extends CommonJsonDbModel {
    private final File fFile;
    private JSONObject fRoot;
    private HashMap<Path, MultiMap<String, Path>> fReversals;
    private static final String kObjectsNode = "objects";
    private static final String kRelnsNode = "relations";

    public SingleFileModel(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this(sc.getExprEval(config).evaluateText(config.getString("modelId")), new File(sc.getExprEval(config).evaluateText(config.getString("file"))));
    }

    public SingleFileModel(String modelId, File f) throws Builder.BuildFailure {
        super(modelId);
        this.fFile = f;
        if (!this.fFile.exists() || this.fFile.length() == 0L) {
            this.fRoot = new JSONObject();
        } else {
            try (FileInputStream fis = new FileInputStream(f);){
                this.fRoot = new JSONObject((JSONTokener)new CommentedJsonTokener((InputStream)fis));
            }
            catch (IOException x) {
                throw new Builder.BuildFailure((Throwable)x);
            }
        }
        if (null == this.fRoot.optJSONObject(kObjectsNode)) {
            this.fRoot.put(kObjectsNode, (Object)new JSONObject());
        }
        if (null == this.fRoot.optJSONArray(kRelnsNode)) {
            this.fRoot.put(kRelnsNode, (Object)new JSONObject());
        }
        this.fReversals = new HashMap();
        this.rebuildReversals();
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path parentPath, PageRequest pr) throws ModelServiceException, ModelRequestException {
        JSONObject current = this.getDataRoot();
        for (Name name : parentPath.getSegments()) {
            if ((current = current.optJSONObject(name.toString())) != null) continue;
            return null;
        }
        LinkedList<Path> paths = new LinkedList<Path>();
        for (String key : current.keySet()) {
            if (null == current.optJSONObject(key)) continue;
            paths.add(parentPath.makeChildItem(Name.fromString((String)key)));
        }
        return ModelPathListPage.wrap(paths, pr);
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        return new ModelQuery();
    }

    @Override
    public Model setRelationType(ModelRequestContext context, String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        return this;
    }

    @Override
    public ModelRelationInstance relate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        JSONObject rootCopy = JsonUtil.clone((JSONObject)this.fRoot);
        try {
            JSONArray relnNode;
            JSONObject relns = this.getRelnRoot();
            JSONObject fromNode = relns.optJSONObject(reln.getFrom().toString());
            if (fromNode == null) {
                fromNode = new JSONObject();
                relns.put(reln.getFrom().toString(), (Object)fromNode);
            }
            if ((relnNode = fromNode.optJSONArray(reln.getName())) == null) {
                relnNode = new JSONArray();
                fromNode.put(reln.getName(), (Object)relnNode);
            }
            String target = reln.getTo().toString();
            List toList = JsonVisitor.arrayToList((JSONArray)relnNode);
            TreeSet toSet = new TreeSet(toList);
            if (!toSet.contains(target)) {
                toList.add(target);
                fromNode.put(reln.getName(), (Object)JsonVisitor.collectionToArray((Collection)toList));
                this.flush();
            }
            return ModelRelationInstance.from(reln);
        }
        catch (ModelServiceException x) {
            this.fRoot = rootCopy;
            throw x;
        }
        catch (Exception x) {
            this.fRoot = rootCopy;
            throw new ModelServiceException(x);
        }
    }

    @Override
    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        JSONObject rootCopy = JsonUtil.clone((JSONObject)this.fRoot);
        try {
            boolean result = this.removeReln(reln);
            this.flush();
            return result;
        }
        catch (ModelServiceException x) {
            this.fRoot = rootCopy;
            throw x;
        }
        catch (Exception x) {
            this.fRoot = rootCopy;
            throw new ModelServiceException(x);
        }
    }

    @Override
    public boolean unrelate(ModelRequestContext context, String relnId) throws ModelServiceException, ModelRequestException {
        try {
            ModelRelationInstance mr = ModelRelationInstance.from(relnId);
            return this.unrelate(context, mr);
        }
        catch (IllegalArgumentException x) {
            throw new ModelRequestException(x);
        }
    }

    @Override
    public List<ModelRelationInstance> getOutboundRelationsNamed(ModelRequestContext context, final Path fromObject, String named) throws ModelServiceException, ModelRequestException {
        final LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
        JsonVisitor.forEachElement((JSONObject)this.getRelnRoot().optJSONObject(fromObject.toString()), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONArray, JSONException>(){

            public boolean visit(final String relnName, JSONArray toList) throws JSONException {
                JsonVisitor.forEachElement((JSONArray)toList, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

                    public boolean visit(String toPathText) throws JSONException {
                        result.add(ModelRelationInstance.from(fromObject, relnName, Path.fromString((String)toPathText)));
                        return true;
                    }
                });
                return true;
            }
        });
        return result;
    }

    @Override
    public List<ModelRelationInstance> getInboundRelationsNamed(ModelRequestContext context, Path toObject, String named) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
        MultiMap<String, Path> revRelns = this.fReversals.get(toObject);
        if (revRelns != null) {
            for (Path fromObj : revRelns.get((Comparable)((Object)named))) {
                result.add(ModelRelationInstance.from(fromObj, named, toObject));
            }
        }
        return result;
    }

    @Override
    protected CommonJsonDbModel.ModelDataTransfer loadObject(ModelRequestContext context, Path objectPath) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        JSONObject current = this.getDataRoot();
        for (Name name : objectPath.getSegments()) {
            if ((current = current.optJSONObject(name.toString())) != null) continue;
            throw new ModelItemDoesNotExistException(objectPath);
        }
        return new CommonDataTransfer(objectPath, current);
    }

    @Override
    protected void internalStore(ModelRequestContext context, Path objectPath, CommonJsonDbModel.ModelDataTransfer o) throws ModelRequestException, ModelServiceException {
        JSONObject rootCopy = JsonUtil.clone((JSONObject)this.fRoot);
        try {
            JSONObject current = this.getDataRoot();
            for (Name name : objectPath.getParentPath().getSegments()) {
                JSONObject next = current.optJSONObject(name.toString());
                if (next == null) {
                    next = new JSONObject();
                    current.put(name.toString(), (Object)next);
                }
                current = next;
            }
            current.put(objectPath.getItemName().toString(), (Object)CommonDataTransfer.toDataObject(o.getMetadata(), o.getObjectData()));
            this.flush();
        }
        catch (ModelServiceException x) {
            this.fRoot = rootCopy;
            throw x;
        }
        catch (Exception x) {
            this.fRoot = rootCopy;
            throw new ModelServiceException(x);
        }
    }

    @Override
    protected boolean internalRemove(ModelRequestContext context, Path objectPath) throws ModelRequestException, ModelServiceException {
        JSONObject rootCopy = JsonUtil.clone((JSONObject)this.fRoot);
        try {
            JSONObject current = this.getDataRoot();
            for (Name name : objectPath.getParentPath().getSegments()) {
                if ((current = current.optJSONObject(name.toString())) != null) continue;
                return false;
            }
            String itemName = objectPath.getItemName().toString();
            if (current.has(itemName) && null != current.optJSONObject(itemName)) {
                current.remove(itemName);
                this.removeRelnsFor(objectPath);
                this.flush();
                return true;
            }
        }
        catch (ModelServiceException x) {
            this.fRoot = rootCopy;
            throw x;
        }
        catch (Exception x) {
            this.fRoot = rootCopy;
            throw new ModelServiceException(x);
        }
        return false;
    }

    private void removeRelnsFor(Path objectPath) {
        this.getRelnRoot().remove(objectPath.toString());
        MultiMap<String, Path> revRelns = this.fReversals.get(objectPath);
        if (revRelns != null) {
            for (Map.Entry entry : revRelns.getValues().entrySet()) {
                for (Path from : (List)entry.getValue()) {
                    this.removeReln(ModelRelation.from(from, (String)entry.getKey(), objectPath));
                }
            }
        }
    }

    private boolean removeReln(ModelRelation reln) {
        JSONObject relns = this.getRelnRoot();
        JSONObject fromNode = relns.optJSONObject(reln.getFrom().toString());
        if (fromNode == null) {
            return false;
        }
        JSONArray relnNode = fromNode.optJSONArray(reln.getName());
        if (relnNode == null) {
            return false;
        }
        boolean result = false;
        String target = reln.getTo().toString();
        List toList = JsonVisitor.arrayToList((JSONArray)relnNode);
        TreeSet tos = new TreeSet(toList);
        if (tos.contains(target)) {
            result = toList.remove(target);
            fromNode.put(reln.getName(), (Object)JsonVisitor.collectionToArray(tos));
            MultiMap<String, Path> revReln = this.fReversals.get(reln.getTo());
            if (revReln != null) {
                revReln.remove((Comparable)((Object)reln.getName()), (Object)reln.getFrom());
            }
        }
        return result;
    }

    private JSONObject getDataRoot() {
        return this.fRoot.getJSONObject(kObjectsNode);
    }

    private JSONObject getRelnRoot() {
        return this.fRoot.getJSONObject(kRelnsNode);
    }

    private void rebuildReversals() {
        this.fReversals.clear();
        JsonVisitor.forEachElement((JSONObject)this.getRelnRoot(), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String fromPathStr, JSONObject relnData) throws JSONException {
                final Path fromPath = Path.fromString((String)fromPathStr);
                JsonVisitor.forEachElement((JSONObject)relnData, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONArray, JSONException>(){

                    public boolean visit(final String relnName, JSONArray toPathList) throws JSONException {
                        JsonVisitor.forEachElement((JSONArray)toPathList, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

                            public boolean visit(String pathText) throws JSONException {
                                MultiMap mm = SingleFileModel.this.fReversals.get(fromPath);
                                if (mm == null) {
                                    mm = new MultiMap();
                                    SingleFileModel.this.fReversals.put(fromPath, (MultiMap<String, Path>)mm);
                                }
                                mm.put((Comparable)((Object)relnName), (Object)Path.fromString((String)pathText));
                                return true;
                            }
                        });
                        return true;
                    }
                });
                return true;
            }
        });
    }

    private void flush() throws ModelServiceException {
        try (FileWriter fw = new FileWriter(this.fFile);){
            fw.write(this.fRoot.toString(4));
        }
        catch (IOException x) {
            throw new ModelServiceException(x);
        }
    }

    private class ModelQuery
    extends SimpleModelQuery {
        private ModelQuery() {
        }

        private List<Path> collectObjectsUnder(Path pathPrefix) {
            LinkedList<Path> result = new LinkedList<Path>();
            JSONObject current = SingleFileModel.this.getDataRoot();
            for (Name name : pathPrefix.getSegments()) {
                if ((current = current.optJSONObject(name.toString())) != null) continue;
                return result;
            }
            for (String key : current.keySet()) {
                if (null == current.optJSONObject(key)) continue;
                Path pathHere = pathPrefix.makeChildItem(Name.fromString((String)key));
                result.add(pathHere);
                result.addAll(this.collectObjectsUnder(pathHere));
            }
            return result;
        }

        @Override
        public <T, K> ModelObjectList<T> execute(ModelRequestContext context, ModelObjectFactory<T, K> factory, final ModelQuery.DataAccessor<T> accessor, K userContext) throws ModelRequestException, ModelServiceException {
            long startIndex;
            final LinkedList<ModelObjectAndPath<T>> result = new LinkedList<ModelObjectAndPath<T>>();
            for (Path p : this.collectObjectsUnder(this.getPathPrefix())) {
                T mo = SingleFileModel.this.load(context, p, factory, userContext);
                if (mo == null) continue;
                boolean match = true;
                for (SimpleModelQuery.Filter filter : this.getFilters()) {
                    if (filter.matches(accessor.getDataFrom(mo))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                result.add(ModelObjectAndPath.from(p, mo));
            }
            final Comparator<ModelObject> orderBy = this.getOrdering();
            if (orderBy != null) {
                Collections.sort(result, new Comparator<ModelObjectAndPath<T>>(){

                    @Override
                    public int compare(ModelObjectAndPath<T> o1, ModelObjectAndPath<T> o2) {
                        return orderBy.compare(accessor.getDataFrom(o1.getObject()), accessor.getDataFrom(o2.getObject()));
                    }
                });
            }
            long toDump = startIndex = (long)this.getPageSize() * (long)this.getPageNumber();
            while (toDump > 0L && result.size() > 0) {
                result.removeFirst();
            }
            while (result.size() > this.getPageSize()) {
                result.removeLast();
            }
            return new ModelObjectList<T>(){

                @Override
                public Iterator<ModelObjectAndPath<T>> iterator() {
                    return result.iterator();
                }
            };
        }
    }
}

