/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.delegator;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelItemList;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BaseRelationSelector;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.services.model.impl.common.SimpleTraversal;
import io.continual.services.model.impl.delegator.ModelMount;
import io.continual.services.model.impl.json.CommonDataTransfer;
import io.continual.services.model.impl.json.CommonJsonDbObjectContainer;
import io.continual.services.model.impl.mem.InMemoryModel;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingModel
extends SimpleService
implements Model {
    private static final String kChild = "child";
    private final String fModelId;
    private final LinkedList<ModelMount> fUserMountTable;
    private final Model fBackingModel;
    private static final Logger log = LoggerFactory.getLogger(DelegatingModel.class);

    public DelegatingModel(ServiceContainer sc, JSONObject config) throws JSONException, Builder.BuildFailure {
        this(config.getString("modelId"), (Model)sc.get("backingModel", Model.class));
    }

    public DelegatingModel(String modelId, Model backingModel) throws Builder.BuildFailure {
        this.fModelId = modelId;
        this.fUserMountTable = new LinkedList();
        this.fBackingModel = backingModel == null ? new InMemoryModel(modelId) : backingModel;
    }

    public DelegatingModel mount(ModelMount mm) {
        this.fUserMountTable.add(mm);
        return this;
    }

    @Override
    public String getId() {
        return this.fModelId;
    }

    @Override
    public long getMaxPathLength() {
        return 0L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 0L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        for (ModelMount mm : this.fUserMountTable) {
            Model m = mm.getModel();
            log.info("Closing " + m.getId());
            m.close();
        }
        this.fBackingModel.close();
    }

    @Override
    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return new BasicModelRequestContextBuilder();
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        try {
            if (objectPath.isRootPath()) {
                return true;
            }
            ModelMount mm = this.getModelForPath(objectPath);
            if (mm.getModel() != this) {
                return mm.getModel().exists(context, mm.getPathWithinModel(objectPath));
            }
            if (!objectPath.isRootPath() && this.fBackingModel.exists(context, objectPath)) {
                return true;
            }
            for (ModelMount um : this.fUserMountTable) {
                Path mp = um.getMountPoint();
                if (!mp.startsWith(objectPath)) continue;
                return true;
            }
            return false;
        }
        catch (ModelRequestException e) {
            return false;
        }
    }

    @Override
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path prefix, PageRequest pr) throws ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(prefix);
        if (mm.getModel() == this) {
            LinkedList<Path> result = new LinkedList<Path>();
            for (ModelMount um : this.fUserMountTable) {
                Path mp = um.getMountPoint();
                if (!mp.startsWith(prefix)) continue;
                Path childPart = mp.makePathWithinParent(prefix);
                result.add(Path.getRootPath().makeChildItem(childPart.getSegments()[0]));
            }
            ModelPathListPage backing = this.fBackingModel.listChildrenOfPath(context, prefix);
            for (Path p : backing) {
                result.add(p);
            }
            return ModelPathListPage.wrap(result, pr);
        }
        return mm.getModel().listChildrenOfPath(context, mm.getPathWithinModel(prefix));
    }

    @Override
    public DelegatingModel createIndex(String field) throws ModelRequestException, ModelServiceException {
        return this;
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        return null;
    }

    @Override
    public ModelTraversal startTraversal() throws ModelRequestException {
        return new SimpleTraversal(this);
    }

    @Override
    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, final K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() != this) {
            return mm.getModel().load(context, mm.getPathWithinModel(objectPath), factory, userContext);
        }
        if (!objectPath.isRootPath() && this.fBackingModel.exists(context, objectPath)) {
            return this.fBackingModel.load(context, objectPath, factory, userContext);
        }
        TreeSet<Path> result = new TreeSet<Path>();
        for (ModelMount modelMount : this.fUserMountTable) {
            Path mp = modelMount.getMountPoint();
            if (!mp.startsWith(objectPath)) continue;
            Path childPart = mp.makePathWithinParent(objectPath);
            result.add(Path.getRootPath().makeChildItem(childPart.getSegments()[0]));
        }
        ModelPathListPage backingModelChildren = this.fBackingModel.listChildrenOfPath(context, objectPath);
        if (objectPath.isRootPath()) {
            for (Path p : backingModelChildren) {
                result.add(p);
            }
        }
        if (backingModelChildren.iterator().hasNext() || result.size() > 0) {
            final CommonDataTransfer commonDataTransfer = CommonJsonDbObjectContainer.createObjectContainer(objectPath, result);
            return factory.create(new ModelObjectFactory.ObjectCreateContext<K>(){

                @Override
                public ModelObjectMetadata getMetadata() {
                    return commonDataTransfer.getMetadata();
                }

                @Override
                public ModelObject getData() {
                    return commonDataTransfer.getObjectData();
                }

                @Override
                public K getUserContext() {
                    return userContext;
                }
            });
        }
        throw new ModelItemDoesNotExistException(objectPath);
    }

    @Override
    public Model.ObjectUpdater createUpdate(ModelRequestContext context, Path objectPath) throws ModelRequestException, ModelServiceException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() == this) {
            return this.fBackingModel.createUpdate(context, objectPath);
        }
        return mm.getModel().createUpdate(context, mm.getPathWithinModel(objectPath));
    }

    @Override
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() == this) {
            return this.fBackingModel.remove(context, objectPath);
        }
        return mm.getModel().remove(context, mm.getPathWithinModel(objectPath));
    }

    @Override
    public Model setRelationType(ModelRequestContext context, String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        this.fBackingModel.setRelationType(context, relnName, rt);
        for (ModelMount mountEntry : this.fUserMountTable) {
            mountEntry.getModel().setRelationType(context, relnName, rt);
        }
        return this;
    }

    @Override
    public ModelRelationInstance relate(ModelRequestContext context, ModelRelation mr) throws ModelServiceException, ModelRequestException {
        Path to;
        ModelMount mmTo;
        Path from = mr.getFrom();
        ModelMount mmFrom = this.getModelForPath(from);
        if (mmFrom == (mmTo = this.getModelForPath(to = mr.getTo()))) {
            return mmFrom.getModel().relate(context, ModelRelation.from(mmFrom.getPathWithinModel(from), mr.getName(), mmTo.getPathWithinModel(to)));
        }
        return this.fBackingModel.relate(context, mr);
    }

    @Override
    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        Path to;
        ModelMount mmTo;
        Path from = reln.getFrom();
        ModelMount mmFrom = this.getModelForPath(from);
        if (mmFrom == (mmTo = this.getModelForPath(to = reln.getTo()))) {
            return mmFrom.getModel().unrelate(context, ModelRelation.from(mmFrom.getPathWithinModel(from), reln.getName(), mmTo.getPathWithinModel(to)));
        }
        return this.fBackingModel.unrelate(context, reln);
    }

    @Override
    public boolean unrelate(ModelRequestContext context, String relnId) throws ModelServiceException, ModelRequestException {
        for (ModelMount mountEntry : this.fUserMountTable) {
            if (!mountEntry.getModel().unrelate(context, relnId)) continue;
            return true;
        }
        this.fBackingModel.unrelate(context, relnId);
        return false;
    }

    @Override
    public Model.RelationSelector selectRelations(Path objectPath) {
        return new BaseRelationSelector<DelegatingModel>(this, objectPath){

            @Override
            public ModelRelationList getRelations(ModelRequestContext context) throws ModelServiceException, ModelRequestException {
                ModelRequestContext dc = DelegatingModel.this.getDerivedContext(DelegatingModel.this.fBackingModel, context);
                LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
                Path objectPath = this.getObject();
                ModelMount mm = DelegatingModel.this.getModelForPath(objectPath);
                String relnNameFilter = this.getNameFilter();
                if (mm.getModel() != DelegatingModel.this) {
                    Path pathInModel = mm.getPathWithinModel(objectPath);
                    ModelRelationList relnList = mm.getModel().selectRelations(pathInModel).named(relnNameFilter).inbound(this.wantInbound()).outbound(this.wantOutbound()).getRelations(DelegatingModel.this.getDerivedContext(mm.getModel(), context));
                    List<ModelRelationInstance> relns = ModelItemList.iterateIntoList(relnList);
                    for (ModelRelationInstance mri : relns) {
                        result.add(ModelRelationInstance.from(mm.getGlobalPath(mri.getFrom()), mri.getName(), mm.getGlobalPath(mri.getTo())));
                    }
                }
                result.addAll(ModelItemList.iterateIntoList(DelegatingModel.this.fBackingModel.selectRelations(objectPath).named(relnNameFilter).inbound(this.wantInbound()).outbound(this.wantOutbound()).getRelations(dc)));
                if (this.wantInbound() && !objectPath.isRootPath() && (relnNameFilter == null || relnNameFilter.equals(DelegatingModel.kChild))) {
                    result.add(ModelRelationInstance.from(objectPath.getParentPath(), DelegatingModel.kChild, objectPath));
                }
                if (this.wantOutbound() && (relnNameFilter == null || relnNameFilter.equals(DelegatingModel.kChild))) {
                    TreeSet<Path> children = new TreeSet<Path>();
                    for (ModelMount mmm : DelegatingModel.this.fUserMountTable) {
                        if (mmm.getMountPoint().startsWith(objectPath) && !mmm.getMountPoint().equals((Object)objectPath)) {
                            Path pInP = mmm.getMountPoint().makePathWithinParent(objectPath);
                            Name childName = pInP.getSegment(0);
                            Path asChild = objectPath.makeChildItem(childName);
                            children.add(asChild);
                            continue;
                        }
                        if (!objectPath.startsWith(mmm.getMountPoint())) continue;
                        for (Path child : mmm.getModel().listChildrenOfPath(DelegatingModel.this.getDerivedContext(mmm.getModel(), context), mmm.getPathWithinModel(objectPath))) {
                            children.add(mmm.getGlobalPath(child));
                        }
                    }
                    for (Path p : DelegatingModel.this.fBackingModel.listChildrenOfPath(dc, objectPath)) {
                        children.add(p);
                    }
                    for (Path child : children) {
                        result.add(ModelRelationInstance.from(objectPath, DelegatingModel.kChild, child));
                    }
                }
                return ModelRelationList.simpleListOfCollection(result);
            }
        };
    }

    private ModelMount getModelForPath(Path modelPath) {
        for (ModelMount mountEntry : this.fUserMountTable) {
            if (!mountEntry.contains(modelPath)) continue;
            return mountEntry;
        }
        return new ModelMount(){

            public JSONObject toJson() {
                return new JSONObject();
            }

            @Override
            public Path getMountPoint() {
                return Path.getRootPath();
            }

            @Override
            public boolean contains(Path path) {
                return true;
            }

            @Override
            public Model getModel() {
                return DelegatingModel.this;
            }

            @Override
            public Path getPathWithinModel(Path absolutePath) {
                return absolutePath;
            }

            @Override
            public Path getGlobalPath(Path from) {
                return from;
            }
        };
    }

    private ModelRequestContext getDerivedContext(Model targetModel, ModelRequestContext mrc) throws ModelRequestException {
        try {
            return targetModel.getRequestContextBuilder().forUser(mrc.getOperator()).build();
        }
        catch (Builder.BuildFailure e) {
            throw new ModelRequestException(e);
        }
    }
}

