/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelItemFilter;
import io.continual.services.model.core.ModelPathList;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class SimpleTraversal
implements ModelTraversal {
    private final Model fModel;
    private final LinkedList<Step> fSteps;
    private Set<Path> fStart;

    public SimpleTraversal(Model m) {
        this.fModel = m;
        this.fStart = null;
        this.fSteps = new LinkedList();
    }

    @Override
    public ModelTraversal startAt(Path p) {
        this.fStart = Collections.singleton(p);
        return this;
    }

    @Override
    public ModelTraversal startWith(Set<Path> p) {
        this.fStart = p;
        return this;
    }

    @Override
    public ModelTraversal traverseOutbound(final String relation) {
        this.fSteps.add(new Step(){

            @Override
            public void execute(StepContext sc) throws ModelRequestException, ModelServiceException {
                TreeSet<Path> result = new TreeSet<Path>();
                for (Path p : sc.fCurrentSet) {
                    for (ModelRelation mr : SimpleTraversal.this.fModel.selectRelations(p).named(relation).outboundOnly().getRelations(sc.fMrc)) {
                        result.add(mr.getTo());
                    }
                }
                sc.replaceSet(result);
            }
        });
        return this;
    }

    @Override
    public ModelTraversal traverseInbound(final String relation) {
        this.fSteps.add(new Step(){

            @Override
            public void execute(StepContext sc) throws ModelRequestException, ModelServiceException {
                TreeSet<Path> result = new TreeSet<Path>();
                for (Path p : sc.fCurrentSet) {
                    for (ModelRelation mr : SimpleTraversal.this.fModel.selectRelations(p).named(relation).inboundOnly().getRelations(sc.fMrc)) {
                        result.add(mr.getFrom());
                    }
                }
                sc.replaceSet(result);
            }
        });
        return this;
    }

    @Override
    public ModelTraversal labelSet(final String label) {
        this.fSteps.add(new Step(){

            @Override
            public void execute(StepContext sc) throws ModelRequestException, ModelServiceException {
                TreeSet<Path> capture = new TreeSet<Path>();
                capture.addAll(sc.fCurrentSet);
                sc.fCaptures.put(label, capture);
            }
        });
        return this;
    }

    @Override
    public ModelTraversal excludeSet(final String label) {
        this.fSteps.add(new Step(){

            @Override
            public void execute(StepContext sc) throws ModelRequestException, ModelServiceException {
                TreeSet<Path> captured = sc.fCaptures.get(label);
                if (captured != null) {
                    TreeSet<Path> newSet = new TreeSet<Path>();
                    for (Path p : sc.fCurrentSet) {
                        if (captured.contains(p)) continue;
                        newSet.add(p);
                    }
                    sc.replaceSet(newSet);
                }
            }
        });
        return this;
    }

    @Override
    public ModelTraversal filterSet(final ModelItemFilter<ModelObject> filter) {
        this.fSteps.add(new Step(){

            @Override
            public void execute(StepContext sc) throws ModelRequestException, ModelServiceException {
                TreeSet<Path> newSet = new TreeSet<Path>();
                for (Path p : sc.fCurrentSet) {
                    BasicModelObject mo = SimpleTraversal.this.fModel.load(sc.fMrc, p);
                    ModelObject moda = mo.getData();
                    if (!filter.matches(moda)) continue;
                    newSet.add(p);
                }
                sc.replaceSet(newSet);
            }
        });
        return this;
    }

    @Override
    public ModelPathList execute(ModelRequestContext context) throws ModelRequestException, ModelServiceException {
        if (this.fStart.isEmpty()) {
            throw new ModelRequestException("Traversal has no start node.");
        }
        StepContext sc = new StepContext(context);
        sc.fCurrentSet.addAll(this.fStart);
        for (Step s : this.fSteps) {
            s.execute(sc);
            if (sc.fCurrentSet.size() != 0) continue;
            break;
        }
        return ModelPathList.wrap(sc.fCurrentSet);
    }

    private class StepContext {
        final ModelRequestContext fMrc;
        TreeSet<Path> fCurrentSet = new TreeSet();
        HashMap<String, TreeSet<Path>> fCaptures = new HashMap();

        public StepContext(ModelRequestContext mrc) {
            this.fMrc = mrc;
        }

        public void replaceSet(TreeSet<Path> set) {
            this.fCurrentSet = set;
        }
    }

    private static interface Step {
        public void execute(StepContext var1) throws ModelRequestException, ModelServiceException;
    }
}

