/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.services.model.core.ModelItemFilter;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.impl.common.ModelObjectExprSource;
import io.continual.util.data.json.JsonPathEval;
import io.continual.util.naming.Path;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public abstract class SimpleModelQuery
implements ModelQuery {
    Path fPathPrefix = Path.getRootPath();
    Comparator<ModelObject> fOrderBy = null;
    int fPageSize = Integer.MAX_VALUE;
    int fPageNumber = 0;
    final LinkedList<Filter> fFilters = new LinkedList();

    @Override
    public ModelQuery withPathPrefix(Path path) {
        this.fPathPrefix = path;
        return this;
    }

    @Override
    public ModelQuery orderBy(Comparator<ModelObject> comparator) {
        this.fOrderBy = comparator;
        return this;
    }

    @Override
    public ModelQuery pageLimit(int pageSize, int pageNumber) {
        this.fPageSize = Math.max(1, pageSize);
        this.fPageNumber = Math.max(0, pageNumber);
        return this;
    }

    @Override
    public ModelQuery matchingJsonPath(final String jsonPath) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                return JsonPathEval.evaluateJsonPath((JSONObject)JsonModelObject.modelObjectToJson(mo), (String)jsonPath).size() > 0;
            }
        });
        return this;
    }

    @Override
    public ModelQuery withFieldValue(final String key, final String val) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                String objVal = ModelObjectExprSource.evalToString(mo, key);
                return val == null && objVal == null || val != null && objVal != null && val.equals(objVal);
            }
        });
        return this;
    }

    @Override
    public ModelQuery withFieldValue(final String key, final long val) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                return val == ModelObjectExprSource.evalToLong(mo, key, 0L);
            }
        });
        return this;
    }

    @Override
    public ModelQuery withFieldValue(final String key, final boolean val) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                return val == ModelObjectExprSource.evalToBoolean(mo, key);
            }
        });
        return this;
    }

    @Override
    public ModelQuery withFieldValue(final String key, final double val) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                return val == ModelObjectExprSource.evalToDouble(mo, key, 0.0);
            }
        });
        return this;
    }

    @Override
    public ModelQuery withFieldContaining(final String key, final String val) {
        this.fFilters.add(new Filter(){

            @Override
            public boolean matches(ModelObject mo) {
                if (val == null) {
                    return false;
                }
                if (val.length() == 0) {
                    return true;
                }
                String objVal = ModelObjectExprSource.evalToString(mo, key);
                return objVal != null && objVal.length() > 0 && objVal.contains(val);
            }
        });
        return this;
    }

    protected Path getPathPrefix() {
        return this.fPathPrefix;
    }

    protected int getPageSize() {
        return this.fPageSize;
    }

    protected int getPageNumber() {
        return this.fPageNumber;
    }

    protected List<Filter> getFilters() {
        return this.fFilters;
    }

    protected Comparator<ModelObject> getOrdering() {
        return this.fOrderBy;
    }

    protected static interface Filter
    extends ModelItemFilter<ModelObject> {
    }
}

