/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.services.model.core.data.JsonModelList;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelList;
import io.continual.services.model.core.data.ModelObject;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.ExprDataSource;

public class ModelObjectExprSource
implements ExprDataSource {
    private final ModelObject fObj;

    public ModelObjectExprSource(ModelObject obj) {
        this.fObj = obj;
    }

    public Object eval(String expression) {
        return ModelObjectExprSource.eval(this.fObj, expression);
    }

    public static String evalToString(ModelObject root, String expression) {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    public static boolean evalToBoolean(ModelObject root, String expression) {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return TypeConvertor.convertToBooleanBroad((String)result.toString());
    }

    public static int evalToInt(ModelObject root, String expression, int defaultValue) {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        return TypeConvertor.convertToInt((String)result.toString(), (int)defaultValue);
    }

    public static long evalToLong(ModelObject root, String expression, long defaultValue) {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        return TypeConvertor.convertToLong((String)result.toString(), (long)defaultValue);
    }

    public static double evalToDouble(ModelObject root, String expression, double defaultValue) {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return TypeConvertor.convertToDouble((String)result.toString(), (double)defaultValue);
    }

    public static ModelObject evalToObject(ModelObject root, String expression) throws IllegalArgumentException {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return new JsonModelObject();
        }
        if (result instanceof ModelObject) {
            return (ModelObject)result;
        }
        throw new IllegalArgumentException(expression + " is not an object.");
    }

    public static ModelList evalToArray(ModelObject root, String expression) throws IllegalArgumentException {
        Object result = ModelObjectExprSource.eval(root, expression);
        if (result == null) {
            return new JsonModelList();
        }
        if (result instanceof ModelList) {
            return (ModelList)result;
        }
        throw new IllegalArgumentException(expression + " is not a list.");
    }

    private static Object eval(ModelObject root, String expression) {
        String[] parts = expression.split("\\.");
        if (parts.length == 1) {
            return ModelObjectExprSource.evalToValue(root, parts[0]);
        }
        ModelObject o = ModelObjectExprSource.evalToContainer(root, parts[0]);
        if (o != null) {
            return ModelObjectExprSource.eval(o, expression.substring(expression.indexOf(46) + 1));
        }
        return null;
    }

    private static Object evalToValue(ModelObject root, String term) {
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]")) {
            return ModelObjectExprSource.termToArrayValue(root, term);
        }
        return root.get(term);
    }

    private static ModelObject evalToContainer(ModelObject root, String term) {
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]")) {
            Object element = ModelObjectExprSource.termToArrayValue(root, term);
            if (element instanceof ModelObject) {
                return (ModelObject)element;
            }
        } else {
            try {
                return root.getMap(term);
            }
            catch (ClassCastException x) {
                return null;
            }
        }
        return null;
    }

    private static Object termToArrayValue(ModelObject root, String term) {
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]")) {
            String key = term.substring(0, openBrace);
            try {
                ModelList a = root.getList(key);
                if (a != null) {
                    try {
                        String indexStr = term.substring(openBrace + 1, term.length() - 1);
                        int index = Integer.parseInt(indexStr);
                        return a.get(index);
                    }
                    catch (NumberFormatException x) {
                        return null;
                    }
                }
            }
            catch (ClassCastException x) {
                return null;
            }
        }
        return null;
    }
}

