/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.builder.Builder;
import io.continual.iam.identity.Identity;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.util.naming.Path;
import java.util.HashMap;
import java.util.TreeSet;

public class BasicModelRequestContext
implements ModelRequestContext {
    private final Identity fUser;
    private final ModelRequestContext.CacheControl fCacheControl;
    private final ModelSchemaRegistry fSchemaReg;
    private final ModelNotificationService fNotificationService;
    private final HashMap<Path, Object> fObjects;
    private final TreeSet<Path> fKnownNotToExist;

    public BasicModelRequestContext(BasicModelRequestContextBuilder mrcBuilder) throws Builder.BuildFailure {
        this.fUser = mrcBuilder.fUser;
        this.fCacheControl = ModelRequestContext.CacheControl.READ_AND_WRITE;
        this.fObjects = new HashMap();
        this.fKnownNotToExist = new TreeSet();
        this.fSchemaReg = mrcBuilder.fSchemaReg;
        this.fNotificationService = mrcBuilder.fNotificationSvc;
    }

    @Override
    public void close() {
    }

    @Override
    public Identity getOperator() {
        return this.fUser;
    }

    @Override
    public ModelRequestContext.CacheControl getCacheControl() {
        return this.fCacheControl;
    }

    @Override
    public <T> T get(Path key, Class<T> clazz) {
        Object o = this.fObjects.get(key);
        return clazz.cast(o);
    }

    @Override
    public void put(Path key, Object o) {
        this.fObjects.put(key, o);
        this.fKnownNotToExist.remove(key);
    }

    @Override
    public void remove(Path objectPath) {
        this.fObjects.remove(objectPath);
        this.fKnownNotToExist.add(objectPath);
    }

    @Override
    public void doesNotExist(Path key) {
        this.fKnownNotToExist.add(key);
        this.fObjects.remove(key);
    }

    @Override
    public boolean knownToNotExist(Path key) {
        return this.fKnownNotToExist.contains(key);
    }

    @Override
    public ModelSchemaRegistry getSchemaRegistry() {
        return this.fSchemaReg;
    }

    @Override
    public ModelNotificationService getNotificationService() {
        return this.fNotificationService;
    }
}

