/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Path;

public abstract class BaseRelationSelector<M extends Model>
implements Model.RelationSelector {
    private final M fModel;
    private final Path fObject;
    private String fNameFilter = null;
    private boolean fInbound = true;
    private boolean fOutbound = true;

    public BaseRelationSelector(M model, Path obj) {
        this.fModel = model;
        this.fObject = obj;
    }

    @Override
    public Model.RelationSelector named(String name) {
        this.fNameFilter = name;
        return this;
    }

    @Override
    public Model.RelationSelector inbound(boolean wantInbound) {
        this.fInbound = wantInbound;
        return this;
    }

    @Override
    public Model.RelationSelector outbound(boolean wantOutbound) {
        this.fOutbound = wantOutbound;
        return this;
    }

    @Override
    public abstract ModelRelationList getRelations(ModelRequestContext var1) throws ModelServiceException, ModelRequestException;

    protected M getModel() {
        return this.fModel;
    }

    protected Path getObject() {
        return this.fObject;
    }

    protected String getNameFilter() {
        return this.fNameFilter;
    }

    protected boolean wantInbound() {
        return this.fInbound;
    }

    protected boolean wantOutbound() {
        return this.fOutbound;
    }

    protected boolean nameMatches(String name) {
        return this.fNameFilter == null || this.fNameFilter.equals(name);
    }
}

