/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.data;

import io.continual.services.model.core.ModelObjectAutoFactory;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Path;
import java.util.Set;
import java.util.TreeSet;

public interface ModelObjectRelnReader {
    public Set<Path> getRemoteObjects() throws ModelRequestException, ModelServiceException;

    default public <T, K> Set<T> getRemoteObjects(Class<T> clazz) throws ModelRequestException, ModelServiceException {
        return this.getRemoteObjects(new ModelObjectAutoFactory(clazz));
    }

    public <T, K> Set<T> getRemoteObjects(ModelObjectFactory<T, K> var1) throws ModelRequestException, ModelServiceException;

    public static ModelObjectRelnReader emptyRelnAccessor() {
        return new ModelObjectRelnReader(){

            @Override
            public Set<Path> getRemoteObjects() {
                return new TreeSet<Path>();
            }

            @Override
            public <T, K> Set<T> getRemoteObjects(ModelObjectFactory<T, K> factory) {
                return new TreeSet();
            }
        };
    }

    default public int size() throws ModelRequestException, ModelServiceException {
        return this.getRemoteObjects().size();
    }
}

