/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.data;

import io.continual.services.model.core.data.ModelList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface ModelObject {
    public Set<String> getKeys();

    default public boolean hasKey(String key) {
        return this.getKeys().contains(key);
    }

    public Object get(String var1);

    default public String getString(String key) {
        return this.optString(key, null);
    }

    default public String optString(String key, String defval) {
        Object val = this.get(key);
        return val == null ? defval : (String)val;
    }

    default public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    default public boolean optBoolean(String key, boolean defval) {
        if (!this.hasKey(key)) {
            return defval;
        }
        return this.getBoolean(key);
    }

    default public Number getNumber(String key) {
        return (Number)this.get(key);
    }

    default public Long getLong(String key) {
        return this.optLong(key, null);
    }

    default public Long optLong(String key, Long defval) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defval;
        }
        return n.longValue();
    }

    default public Integer getInt(String key) {
        return this.optInt(key, null);
    }

    default public Integer optInt(String key, Integer defval) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defval;
        }
        return n.intValue();
    }

    default public ModelObject getMap(String key) {
        return (ModelObject)this.get(key);
    }

    default public ModelList getList(String key) {
        return (ModelList)this.get(key);
    }

    default public Iterable<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.getKeys()) {
            map.put(key, this.get(key));
        }
        return map.entrySet();
    }

    public ModelObject putNull(String var1);

    public ModelObject put(String var1, String var2);

    public ModelObject put(String var1, Number var2);

    public ModelObject put(String var1, boolean var2);

    public ModelObject put(String var1, ModelObject var2);

    public ModelObject put(String var1, ModelList var2);
}

