/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.data;

import io.continual.services.model.core.data.ModelObject;
import java.util.LinkedList;
import java.util.List;

public interface ModelList {
    public int size();

    public Object get(int var1);

    default public String getString(int index) {
        Object val = this.get(index);
        return val == null ? null : (String)val;
    }

    default public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    default public Number getNumber(int index) {
        return (Number)this.get(index);
    }

    default public ModelObject getMap(int index) {
        return (ModelObject)this.get(index);
    }

    default public ModelList getList(int index) {
        return (ModelList)this.get(index);
    }

    default public <T> void forEach(Visitor<T> v) {
        for (int i = 0; i < this.size(); ++i) {
            v.visit(this.get(i));
        }
    }

    default public <T> List<T> listOf(Class<T> clazz) {
        LinkedList result = new LinkedList();
        this.forEach(t -> result.add(t));
        return result;
    }

    default public ModelList addNull() {
        return this.putNull(this.size());
    }

    default public ModelList add(String val) {
        return this.put(this.size(), val);
    }

    default public ModelList add(Number val) {
        return this.put(this.size(), val);
    }

    default public ModelList add(boolean val) {
        return this.put(this.size(), val);
    }

    default public ModelList add(ModelObject val) {
        return this.put(this.size(), val);
    }

    default public ModelList add(ModelList val) {
        return this.put(this.size(), val);
    }

    public ModelList putNull(int var1);

    public ModelList put(int var1, String var2);

    public ModelList put(int var1, Number var2);

    public ModelList put(int var1, boolean var2);

    public ModelList put(int var1, ModelObject var2);

    public ModelList put(int var1, ModelList var2);

    public static interface Visitor<T> {
        public void visit(T var1);
    }
}

