/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.data;

import io.continual.services.model.core.data.JsonModelList;
import io.continual.services.model.core.data.ModelList;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.data.ModelObjectNullValue;
import io.continual.util.data.json.JsonUtil;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonModelObject
implements ModelObject {
    private final JSONObject fData;

    public JsonModelObject() {
        this.fData = new JSONObject();
    }

    public JsonModelObject(JSONObject data) {
        this.fData = data;
    }

    public JsonModelObject clear() {
        this.fData.clear();
        return this;
    }

    public JsonModelObject merge(ModelObject data) {
        JsonUtil.overlay((JSONObject)this.fData, (JSONObject)JsonModelObject.modelObjectToJson(data));
        return this;
    }

    @Override
    public Set<String> getKeys() {
        return this.fData.keySet();
    }

    @Override
    public Object get(String key) {
        Object val = this.fData.opt(key);
        return val == null ? null : JsonModelObject.jsonToIface(val);
    }

    @Override
    public JsonModelObject putNull(String key) {
        this.fData.put(key, JSONObject.NULL);
        return this;
    }

    @Override
    public JsonModelObject put(String key, String val) {
        this.fData.put(key, (Object)val);
        return this;
    }

    @Override
    public JsonModelObject put(String key, Number val) {
        this.fData.put(key, (Object)val);
        return this;
    }

    @Override
    public JsonModelObject put(String key, boolean val) {
        this.fData.put(key, val);
        return this;
    }

    @Override
    public JsonModelObject put(String key, ModelObject val) {
        this.fData.put(key, JsonModelObject.ifaceToJson(val));
        return this;
    }

    @Override
    public JsonModelObject put(String key, ModelList val) {
        this.fData.put(key, JsonModelObject.ifaceToJson(val));
        return this;
    }

    public static JSONObject modelObjectToJson(ModelObject mo) {
        if (mo instanceof JsonModelObject) {
            return JsonUtil.clone((JSONObject)((JsonModelObject)mo).fData);
        }
        return (JSONObject)JsonModelObject.ifaceToJson(mo);
    }

    static Object jsonToIface(Object internalObject) {
        if (internalObject instanceof JSONObject) {
            return new JsonModelObject((JSONObject)internalObject);
        }
        if (internalObject instanceof JSONArray) {
            return new JsonModelList((JSONArray)internalObject);
        }
        if (internalObject == JSONObject.NULL) {
            return ModelObjectNullValue.NULL;
        }
        return internalObject;
    }

    static Object ifaceToJson(Object ifaceObject) {
        if (ifaceObject instanceof ModelObject) {
            ModelObject mo = (ModelObject)ifaceObject;
            JSONObject result = new JSONObject();
            for (Map.Entry<String, Object> e : mo.entrySet()) {
                result.put(e.getKey(), JsonModelObject.ifaceToJson(e.getValue()));
            }
            return result;
        }
        if (ifaceObject instanceof ModelList) {
            ModelList ml = (ModelList)ifaceObject;
            JSONArray result = new JSONArray();
            for (int i = 0; i < ml.size(); ++i) {
                result.put(JsonModelObject.ifaceToJson(ml.get(i)));
            }
            return result;
        }
        if (ifaceObject == ModelObjectNullValue.NULL) {
            return JSONObject.NULL;
        }
        return ifaceObject;
    }
}

