/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.data;

import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelList;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.data.ModelObjectNullValue;
import org.json.JSONArray;

public class JsonModelList
implements ModelList {
    private final JSONArray fData;

    public JsonModelList() {
        this.fData = new JSONArray();
    }

    JsonModelList(JSONArray data) {
        this.fData = data;
    }

    @Override
    public int size() {
        return this.fData.length();
    }

    @Override
    public Object get(int index) {
        return JsonModelObject.jsonToIface(this.fData.get(index));
    }

    @Override
    public ModelList putNull(int index) {
        return this.put(index, ModelObjectNullValue.NULL);
    }

    @Override
    public ModelList put(int index, String val) {
        return this.put(index, val);
    }

    @Override
    public ModelList put(int index, Number val) {
        return this.put(index, val);
    }

    @Override
    public ModelList put(int index, boolean val) {
        return this.put(index, val);
    }

    @Override
    public ModelList put(int index, ModelObject val) {
        return this.put(index, val);
    }

    @Override
    public ModelList put(int index, ModelList val) {
        return this.put(index, val);
    }

    private ModelList put(int index, Object val) {
        if (index < 0) {
            throw new IllegalArgumentException("List index is " + index);
        }
        while (index > this.size()) {
            this.putNull(this.size());
        }
        this.fData.put(index, JsonModelObject.ifaceToJson(val));
        return this;
    }
}

