/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.PageRequest;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PagingIterWrapper<T>
implements Iterator<T> {
    private final Iterator<T> fIter;
    private int fSkipsLeft;
    private int fItemsLeft;

    public PagingIterWrapper(Iterator<T> iterator, PageRequest pr) {
        this.fIter = iterator;
        this.fSkipsLeft = pr.getRequestedPage() * pr.getRequestedPageSize();
        this.fItemsLeft = pr.getRequestedPageSize();
    }

    @Override
    public boolean hasNext() {
        this.initialPageSkip();
        return this.fItemsLeft > 0 && this.fIter.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.initialPageSkip();
        --this.fItemsLeft;
        return this.fIter.next();
    }

    private void initialPageSkip() {
        while (this.fSkipsLeft > 0 && this.fIter.hasNext()) {
            --this.fSkipsLeft;
            this.fIter.next();
        }
    }
}

