/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelRelation;
import io.continual.util.data.TypeConvertor;
import io.continual.util.naming.Path;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public interface ModelRelationInstance
extends ModelRelation {
    public String getId();

    public static ModelRelationInstance from(Path from, String reln, Path to) {
        return ModelRelationInstance.from(ModelRelation.from(from, reln, to));
    }

    public static ModelRelationInstance from(final ModelRelation mr) {
        final String id = ModelRelationInstance.makeId(mr);
        return new ModelRelationInstance(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public Path getFrom() {
                return mr.getFrom();
            }

            @Override
            public Path getTo() {
                return mr.getTo();
            }

            @Override
            public String getName() {
                return mr.getName();
            }

            public String toString() {
                return this.getFrom() + " --" + this.getName() + "-> " + this.getTo() + " (" + this.getId() + ")";
            }

            public int hashCode() {
                return mr.hashCode();
            }

            public boolean equals(Object that) {
                return mr.equals(that);
            }

            @Override
            public int compareTo(ModelRelation o) {
                return mr.compareTo(o);
            }
        };
    }

    public static ModelRelationInstance from(String id) throws IllegalArgumentException {
        ModelRelationInstance modelRelationInstance;
        ByteArrayInputStream bais = new ByteArrayInputStream(TypeConvertor.base64Decode((String)id));
        try {
            JSONObject json = new JSONObject(new JSONTokener((InputStream)bais));
            modelRelationInstance = ModelRelationInstance.from(Path.fromString((String)json.getString("from")), json.getString("name"), Path.fromString((String)json.getString("to")));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JSONException x) {
                throw new IllegalArgumentException(x);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        bais.close();
        return modelRelationInstance;
    }

    public static String makeId(ModelRelation mr) {
        return TypeConvertor.base64Encode((String)new JSONObject().put("from", (Object)mr.getFrom().toString()).put("name", (Object)mr.getName()).put("to", (Object)mr.getTo().toString()).toString()).trim();
    }
}

