/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.util.naming.Path;
import java.util.Objects;

public interface ModelRelation
extends Comparable<ModelRelation> {
    public Path getFrom();

    public Path getTo();

    public String getName();

    public static ModelRelation from(final Path from, final String reln, final Path to) {
        return new ModelRelation(){

            @Override
            public Path getFrom() {
                return from;
            }

            @Override
            public Path getTo() {
                return to;
            }

            @Override
            public String getName() {
                return reln;
            }

            public String toString() {
                return this.getFrom() + "->" + this.getName() + "->" + this.getTo();
            }

            public int hashCode() {
                return Objects.hash(this.getFrom(), this.getName(), this.getTo());
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ModelRelation that = (ModelRelation)obj;
                return Objects.equals(this.getFrom(), that.getFrom()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getTo(), that.getTo());
            }

            @Override
            public int compareTo(ModelRelation o) {
                int result = from.compareTo(o.getFrom());
                if (result != 0) {
                    return result;
                }
                result = reln.compareTo(o.getName());
                if (result != 0) {
                    return result;
                }
                result = to.compareTo(o.getTo());
                if (result != 0) {
                    return result;
                }
                return 0;
            }
        };
    }

    public static int compare(ModelRelation mr1, ModelRelation mr2) {
        int c = mr1.getFrom().compareTo(mr2.getFrom());
        if (c != 0) {
            return c;
        }
        c = mr1.getName().compareTo(mr2.getName());
        if (c != 0) {
            return c;
        }
        return mr1.getTo().compareTo(mr2.getTo());
    }
}

