/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelObjectAutoFactory;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Path;
import java.util.Comparator;

public interface ModelQuery {
    public ModelQuery withPathPrefix(Path var1);

    public ModelQuery matchingJsonPath(String var1);

    public ModelQuery withFieldValue(String var1, String var2);

    public ModelQuery withFieldValue(String var1, long var2);

    public ModelQuery withFieldValue(String var1, boolean var2);

    public ModelQuery withFieldValue(String var1, double var2);

    public ModelQuery withFieldContaining(String var1, String var2);

    public ModelQuery orderBy(Comparator<ModelObject> var1);

    public ModelQuery pageLimit(int var1, int var2);

    default public ModelQuery pageLimit(PageRequest pr) {
        return this.pageLimit(pr.getRequestedPage(), pr.getRequestedPageSize());
    }

    default public ModelObjectList<BasicModelObject> execute(ModelRequestContext context) throws ModelRequestException, ModelServiceException {
        return this.execute(context, new ModelObjectAutoFactory(BasicModelObject.class), new DataAccessor<BasicModelObject>(){

            @Override
            public ModelObject getDataFrom(BasicModelObject obj) {
                return obj.getData();
            }
        }, null);
    }

    public <T, K> ModelObjectList<T> execute(ModelRequestContext var1, ModelObjectFactory<T, K> var2, DataAccessor<T> var3, K var4) throws ModelRequestException, ModelServiceException;

    public static interface DataAccessor<T> {
        public ModelObject getDataFrom(T var1);
    }
}

