/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelItemListPage;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.PagingIterWrapper;
import io.continual.util.naming.Path;
import java.util.Iterator;
import java.util.LinkedList;

public interface ModelPathListPage
extends ModelItemListPage<Path> {
    public static ModelPathListPage emptyList(PageRequest pr) {
        return ModelPathListPage.wrap(new LinkedList<Path>(), pr);
    }

    public static ModelPathListPage wrap(final LinkedList<Path> result, final PageRequest pr) {
        return new ModelPathListPage(){
            final PagingIterWrapper<Path> iter;
            {
                this.iter = new PagingIterWrapper(result.iterator(), pr);
            }

            @Override
            public long getTotalItemCount() {
                return result.size();
            }

            @Override
            public PageRequest getPageRequest() {
                return pr;
            }

            @Override
            public Iterator<Path> iterator() {
                return this.iter;
            }

            @Override
            public long getItemCountOnPage() {
                long lastPageIndex;
                long pageSize = this.getPageRequest().getRequestedPageSize();
                long pages = this.getTotalPageCount();
                long thisPage = this.getCurrentPageNumber();
                if (thisPage < (lastPageIndex = pages - 1L)) {
                    return pageSize;
                }
                if (thisPage > lastPageIndex) {
                    return 0L;
                }
                return this.getTotalItemCount() - lastPageIndex * (long)this.getPageRequest().getRequestedPageSize();
            }

            @Override
            public long getTotalPageCount() {
                long totalCount = this.getTotalItemCount();
                return Math.round(Math.ceil((double)totalCount / (double)pr.getRequestedPageSize()));
            }
        };
    }

    public static ModelPathListPage wrap(final ModelPathListPage mplp, final PathTransform pt) {
        return new ModelPathListPage(){

            @Override
            public PageRequest getPageRequest() {
                return mplp.getPageRequest();
            }

            @Override
            public long getItemCountOnPage() {
                return mplp.getItemCountOnPage();
            }

            @Override
            public long getTotalItemCount() {
                return mplp.getTotalItemCount();
            }

            @Override
            public long getTotalPageCount() {
                return mplp.getTotalPageCount();
            }

            @Override
            public Iterator<Path> iterator() {
                final Iterator baseIter = mplp.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return baseIter.hasNext();
                    }

                    @Override
                    public Path next() {
                        return pt.transform((Path)baseIter.next());
                    }
                };
            }
        };
    }

    public static interface PathTransform {
        public Path transform(Path var1);
    }
}

