/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelItemList;
import io.continual.services.model.core.ModelObjectAndPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface ModelObjectList<T>
extends ModelItemList<ModelObjectAndPath<T>> {
    public static ModelObjectList<?> emptyList() {
        return ModelObjectList.simpleList(new ModelObjectAndPath[0]);
    }

    public static <T> ModelObjectList<T> emptyList(Class<T> clazz) {
        final LinkedList list = new LinkedList();
        return new ModelObjectList<T>(){

            @Override
            public Iterator<ModelObjectAndPath<T>> iterator() {
                return list.iterator();
            }
        };
    }

    @SafeVarargs
    public static <T> ModelObjectList<T> simpleList(ModelObjectAndPath<T> ... instances) {
        final List<ModelObjectAndPath<T>> list = Arrays.asList(instances);
        return new ModelObjectList<T>(){

            @Override
            public Iterator<ModelObjectAndPath<T>> iterator() {
                return list.iterator();
            }
        };
    }

    public static <T> ModelObjectList<T> simpleListOfCollection(final Collection<ModelObjectAndPath<T>> instances) {
        return new ModelObjectList<T>(){

            @Override
            public Iterator<ModelObjectAndPath<T>> iterator() {
                return instances.iterator();
            }
        };
    }
}

